/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.gameObjs.EnumRelayTier;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import moze_intel.projecte.gameObjs.tiles.RelayMK2Tile;
import moze_intel.projecte.gameObjs.tiles.RelayMK3Tile;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class Relay
extends BlockDirection {
    private final EnumRelayTier tier;

    public Relay(EnumRelayTier tier, Block.Properties props) {
        super(props);
        this.tier = tier;
    }

    public EnumRelayTier getTier() {
        return this.tier;
    }

    @Deprecated
    public boolean func_220051_a(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult rtr) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof RelayMK1Tile) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((RelayMK1Tile)te), (BlockPos)pos);
        }
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        switch (this.tier) {
            case MK1: {
                return new RelayMK1Tile();
            }
            case MK2: {
                return new RelayMK2Tile();
            }
            case MK3: {
                return new RelayMK3Tile();
            }
        }
        return null;
    }

    @Deprecated
    public boolean func_149740_M(@Nonnull BlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(@Nonnull BlockState state, World world, @Nonnull BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RelayMK1Tile) {
            RelayMK1Tile relay = (RelayMK1Tile)te;
            return MathUtils.scaleToRedstone(relay.getStoredEmc(), relay.getMaximumEmc());
        }
        return 0;
    }

    @Override
    public void func_196243_a(BlockState state, World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te != null) {
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).ifPresent(inv -> WorldHelper.dropInventory(inv, world, pos));
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }
}

