/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.entity;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import moze_intel.projecte.gameObjs.ObjHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityHomingArrow
extends ArrowEntity {
    private static final DataParameter<Integer> DW_TARGET_ID = EntityDataManager.func_187226_a(EntityHomingArrow.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int NO_TARGET = -1;
    private int newTargetCooldown = 0;

    public EntityHomingArrow(EntityType<EntityHomingArrow> type, World world) {
        super(type, world);
    }

    public EntityHomingArrow(World world, LivingEntity shooter, float damage) {
        super(world, shooter);
        this.func_70239_b(damage);
        this.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
    }

    @Nonnull
    public EntityType<?> func_200600_R() {
        return ObjHandler.HOMING_ARROW;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_TARGET_ID, (Object)-1);
    }

    protected void func_184548_a(@Nonnull LivingEntity living) {
        super.func_184548_a(living);
        living.field_70172_ad = 0;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 3) {
            if (this.hasTarget() && (!this.getTarget().func_70089_S() || this.field_70254_i)) {
                this.field_70180_af.func_187227_b(DW_TARGET_ID, (Object)-1);
            }
            if (!this.hasTarget() && !this.field_70254_i && this.newTargetCooldown <= 0) {
                this.findNewTarget();
            } else {
                --this.newTargetCooldown;
            }
        }
        if (this.field_70173_aa > 3 && this.hasTarget() && !this.field_70254_i) {
            double mX = this.func_213322_ci().func_82615_a();
            double mY = this.func_213322_ci().func_82617_b();
            double mZ = this.func_213322_ci().func_82616_c();
            this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.field_70165_t + mX / 4.0, this.field_70163_u + mY / 4.0, this.field_70161_v + mZ / 4.0, -mX / 2.0, -mY / 2.0 + 0.2, -mZ / 2.0);
            this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.field_70165_t + mX / 4.0, this.field_70163_u + mY / 4.0, this.field_70161_v + mZ / 4.0, -mX / 2.0, -mY / 2.0 + 0.2, -mZ / 2.0);
            MobEntity target = this.getTarget();
            Vector3d arrowLoc = new Vector3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vector3d targetLoc = new Vector3d(target.field_70165_t, target.field_70163_u + (double)(target.func_213302_cg() / 2.0f), target.field_70161_v);
            Vector3d lookVec = new Vector3d(targetLoc);
            lookVec.sub((Tuple3d)arrowLoc);
            Vector3d arrowMotion = new Vector3d(mX, mY, mZ);
            double theta = this.wrap180Radian(arrowMotion.angle(lookVec));
            theta = this.clampAbs(theta, 1.5707963267948966);
            Vector3d crossProduct = new Vector3d();
            crossProduct.cross(arrowMotion, lookVec);
            crossProduct.normalize();
            Matrix4d transform = new Matrix4d();
            transform.set(new AxisAngle4d(crossProduct, theta));
            Vector3d adjustedLookVec = new Vector3d(arrowMotion);
            transform.transform(arrowMotion, adjustedLookVec);
            this.func_70186_c(adjustedLookVec.x, adjustedLookVec.y, adjustedLookVec.z, 1.0f, 0.0f);
        }
        super.func_70071_h_();
    }

    @Nonnull
    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)Items.field_151032_g);
    }

    private void findNewTarget() {
        List candidates = this.field_70170_p.func_217357_a(MobEntity.class, this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
        if (!candidates.isEmpty()) {
            candidates.sort(Comparator.comparing(arg_0 -> ((EntityHomingArrow)this).func_70068_e(arg_0), Double::compare));
            this.field_70180_af.func_187227_b(DW_TARGET_ID, (Object)((MobEntity)candidates.get(0)).func_145782_y());
        }
        this.newTargetCooldown = 5;
    }

    private MobEntity getTarget() {
        return (MobEntity)this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(DW_TARGET_ID)).intValue());
    }

    private boolean hasTarget() {
        return this.getTarget() != null;
    }

    private double wrap180Radian(double radian) {
        radian %= Math.PI * 2;
        while (radian >= Math.PI) {
            radian -= Math.PI * 2;
        }
        while (radian < -Math.PI) {
            radian += Math.PI * 2;
        }
        return radian;
    }

    private double clampAbs(double param, double maxMagnitude) {
        if (Math.abs(param) > maxMagnitude) {
            param = param < 0.0 ? -Math.abs(maxMagnitude) : Math.abs(maxMagnitude);
        }
        return param;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

