/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Locale;
import moze_intel.projecte.gameObjs.container.TransmutationContainer;
import moze_intel.projecte.gameObjs.container.inventory.TransmutationInventory;
import moze_intel.projecte.gameObjs.gui.PEContainerScreen;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.TransmutationEMCFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GUITransmutation
extends PEContainerScreen<TransmutationContainer> {
    private static final ResourceLocation texture = new ResourceLocation("projecte", "textures/gui/transmute.png");
    private final TransmutationInventory inv;
    private TextFieldWidget textBoxFilter;

    public GUITransmutation(TransmutationContainer container, PlayerInventory invPlayer, ITextComponent title) {
        super(container, invPlayer, title);
        this.inv = container.transmutationInventory;
        this.field_146999_f = 228;
        this.field_147000_g = 196;
    }

    public void init() {
        super.init();
        this.textBoxFilter = new TextFieldWidget(this.font, this.field_147003_i + 88, this.field_147009_r + 8, 45, 10, "");
        this.textBoxFilter.func_146180_a(this.inv.filter);
        this.addButton((Widget)new Button(this.field_147003_i + 125, this.field_147009_r + 100, 14, 14, "<", b -> {
            if (this.inv.searchpage != 0) {
                --this.inv.searchpage;
            }
            this.inv.filter = this.textBoxFilter.func_146179_b().toLowerCase(Locale.ROOT);
            this.inv.updateClientTargets();
        }));
        this.addButton((Widget)new Button(this.field_147003_i + 193, this.field_147009_r + 100, 14, 14, ">", b -> {
            if (this.inv.getKnowledgeSize() > 12) {
                ++this.inv.searchpage;
            }
            this.inv.filter = this.textBoxFilter.func_146179_b().toLowerCase(Locale.ROOT);
            this.inv.updateClientTargets();
        }));
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.textBoxFilter.render(mouseX, mouseY, partialTicks);
    }

    protected void func_146979_b(int var1, int var2) {
        this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.transmute", (Object[])new Object[0]), 6.0f, 8.0f, 0x404040);
        BigInteger emcAmount = this.inv.getAvailableEMC();
        String emcLabel = I18n.func_135052_a((String)"pe.emc.emc_tooltip_prefix", (Object[])new Object[0]);
        this.font.func_211126_b(emcLabel, 6.0f, (float)(this.field_147000_g - 104), 0x404040);
        String emc = TransmutationEMCFormatter.formatEMC(emcAmount);
        this.font.func_211126_b(emc, 6.0f, (float)(this.field_147000_g - 94), 0x404040);
        if (this.inv.learnFlag > 0) {
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.learned0", (Object[])new Object[0]), 98.0f, 30.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.learned1", (Object[])new Object[0]), 99.0f, 38.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.learned2", (Object[])new Object[0]), 100.0f, 46.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.learned3", (Object[])new Object[0]), 101.0f, 54.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.learned4", (Object[])new Object[0]), 102.0f, 62.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.learned5", (Object[])new Object[0]), 103.0f, 70.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.learned6", (Object[])new Object[0]), 104.0f, 78.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.learned7", (Object[])new Object[0]), 107.0f, 86.0f, 0x404040);
            --this.inv.learnFlag;
        }
        if (this.inv.unlearnFlag > 0) {
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.unlearned0", (Object[])new Object[0]), 97.0f, 22.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.unlearned1", (Object[])new Object[0]), 98.0f, 30.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.unlearned2", (Object[])new Object[0]), 99.0f, 38.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.unlearned3", (Object[])new Object[0]), 100.0f, 46.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.unlearned4", (Object[])new Object[0]), 101.0f, 54.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.unlearned5", (Object[])new Object[0]), 102.0f, 62.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.unlearned6", (Object[])new Object[0]), 103.0f, 70.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.unlearned7", (Object[])new Object[0]), 104.0f, 78.0f, 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"pe.transmutation.unlearned8", (Object[])new Object[0]), 107.0f, 86.0f, 0x404040);
            --this.inv.unlearnFlag;
        }
    }

    public void tick() {
        super.tick();
        this.textBoxFilter.func_146178_a();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.textBoxFilter.isFocused()) {
            if (keyCode == 256) {
                this.textBoxFilter.func_146195_b(false);
                return true;
            }
            if (this.textBoxFilter.keyPressed(keyCode, scanCode, modifiers)) {
                this.updateFilter();
                return true;
            }
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        if (this.textBoxFilter.isFocused()) {
            if (this.textBoxFilter.charTyped(c, keyCode)) {
                this.updateFilter();
                return true;
            }
            return false;
        }
        return super.charTyped(c, keyCode);
    }

    private void updateFilter() {
        String search = this.textBoxFilter.func_146179_b().toLowerCase();
        if (!this.inv.filter.equals(search)) {
            this.inv.filter = search;
            this.inv.searchpage = 0;
            this.inv.updateClientTargets();
        }
    }

    public boolean mouseClicked(double x, double y, int mouseButton) {
        int minX = this.textBoxFilter.x;
        int minY = this.textBoxFilter.y;
        int maxX = minX + this.textBoxFilter.getWidth();
        int maxY = minY + this.textBoxFilter.getHeight();
        if (x >= (double)minX && x <= (double)maxX && y <= (double)maxY) {
            if (mouseButton == 1) {
                this.inv.filter = "";
                this.inv.searchpage = 0;
                this.inv.updateClientTargets();
                this.textBoxFilter.func_146180_a("");
            }
            return this.textBoxFilter.mouseClicked(x, y, mouseButton);
        }
        return super.mouseClicked(x, y, mouseButton);
    }

    public void onClose() {
        super.onClose();
        this.inv.learnFlag = 0;
        this.inv.unlearnFlag = 0;
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        BigInteger emcAmount = this.inv.getAvailableEMC();
        if (emcAmount.compareTo(Constants.MAX_EXACT_TRANSMUTATION_DISPLAY) < 0) {
            super.func_191948_b(mouseX, mouseY);
            return;
        }
        int emcLeft = this.field_147003_i;
        int emcRight = emcLeft + 82;
        int emcTop = 95 + this.field_147009_r;
        int emcBottom = emcTop + 15;
        if (mouseX > emcLeft && mouseX < emcRight && mouseY > emcTop && mouseY < emcBottom) {
            String emcAsString = I18n.func_135052_a((String)"pe.emc.emc_tooltip_prefix", (Object[])new Object[0]) + " " + Constants.EMC_FORMATTER.format(emcAmount);
            this.renderTooltip(Collections.singletonList(emcAsString), mouseX, mouseY);
        } else {
            super.func_191948_b(mouseX, mouseY);
        }
    }
}

