/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.items.CataliticLens;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DestructionCatalyst
extends ItemPE
implements IItemCharge {
    public DestructionCatalyst(Item.Properties props) {
        super(props);
        this.addItemCapability(new ChargeItemCapabilityWrapper());
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        int numRows = this.calculateDepthFromCharge(stack);
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(WorldHelper.getDeepBox(ctx.func_195995_a(), ctx.func_196000_l(), --numRows))) {
            BlockState state;
            float hardness;
            if (world.func_175623_d(pos) || (hardness = (state = world.func_180495_p(pos)).func_185887_b((IBlockReader)world, pos)) == -1.0f || hardness >= 50.0f) continue;
            if (!DestructionCatalyst.consumeFuel(player, stack, 8L, true)) break;
            hasAction = true;
            if (!PlayerHelper.hasBreakPermission((ServerPlayerEntity)player, pos = pos.func_185334_h())) continue;
            List list = Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)player, (ItemStack)stack);
            drops.addAll(list);
            world.func_217377_a(pos, false);
            if (world.field_73012_v.nextInt(8) != 0) continue;
            ((ServerWorld)world).func_195598_a((IParticleData)(world.field_73012_v.nextBoolean() ? ParticleTypes.field_197598_I : ParticleTypes.field_197594_E), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 2, 0.0, 0.0, 0.0, 0.05);
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, world, ctx.func_195995_a());
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.DESTRUCT, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return ActionResultType.SUCCESS;
    }

    private int calculateDepthFromCharge(ItemStack stack) {
        int charge = this.getCharge(stack);
        if (charge <= 0) {
            return 1;
        }
        if (this instanceof CataliticLens) {
            return 8 + 8 * charge;
        }
        return (int)Math.pow(2.0, 1 + charge);
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return 3;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getChargePercent(stack);
    }
}

