/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.BasicItemCapability;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityWaterProjectile;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.FluidHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class EvertideAmulet
extends ItemPE
implements IProjectileShooter,
IPedestalItem {
    private static final AttributeModifier SPEED_BOOST = new AttributeModifier("Walk on water speed boost", 0.15, AttributeModifier.Operation.ADDITION).func_111168_a(false);

    public EvertideAmulet(Item.Properties props) {
        super(props);
        this.addItemCapability(new PedestalItemCapabilityWrapper());
        this.addItemCapability(new InfiniteFluidHandler());
        this.addItemCapability(new ProjectileShooterItemCapabilityWrapper());
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.func_77946_l();
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        BlockPos pos = ctx.func_195995_a();
        if (!world.field_72995_K && PlayerHelper.hasEditPermission((ServerPlayerEntity)player, pos)) {
            TileEntity tile = world.func_175625_s(pos);
            Direction sideHit = ctx.func_196000_l();
            if (tile != null && tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideHit).isPresent()) {
                FluidHelper.tryFillTank(tile, (Fluid)Fluids.field_204546_a, sideHit, 1000);
            } else {
                BlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() == Blocks.field_150383_bp) {
                    int waterLevel = (Integer)state.func_177229_b((IProperty)CauldronBlock.field_176591_a);
                    if (waterLevel < 3) {
                        ((CauldronBlock)state.func_177230_c()).func_176590_a(world, pos, state, waterLevel + 1);
                    }
                } else {
                    WorldHelper.placeFluid((ServerPlayerEntity)player, world, pos, sideHit, Fluids.field_204546_a, (Boolean)ProjectEConfig.server.items.opEvertide.get() == false);
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.WATER, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        if (player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(SPEED_BOOST)) {
            player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(SPEED_BOOST);
        }
        return true;
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull Entity entity, int invSlot, boolean par5) {
        int z;
        int y;
        if (invSlot > 8 || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        int x = (int)Math.floor(living.field_70165_t);
        BlockPos pos = new BlockPos(x, y = (int)(living.field_70163_u - living.func_70033_W()), z = (int)Math.floor(living.field_70161_v));
        if (world.func_204610_c(pos.func_177977_b()).func_206886_c().func_207185_a(FluidTags.field_206959_a) && world.func_175623_d(pos)) {
            if (!living.func_70093_af()) {
                living.func_213317_d(living.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
                living.field_70143_R = 0.0f;
                living.field_70122_E = true;
            }
            if (!world.field_72995_K && !living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(SPEED_BOOST)) {
                living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(SPEED_BOOST);
            }
        } else if (!world.field_72995_K) {
            if (living.func_70090_H()) {
                living.func_70050_g(300);
            }
            if (living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(SPEED_BOOST)) {
                living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(SPEED_BOOST);
            }
        }
    }

    @Override
    public boolean shootProjectile(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, Hand hand) {
        World world = player.func_130014_f_();
        if (((Boolean)ProjectEConfig.server.items.opEvertide.get()).booleanValue() || !world.field_73011_w.func_177500_n()) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.WATER, SoundCategory.PLAYERS, 1.0f, 1.0f);
            EntityWaterProjectile ent = new EntityWaterProjectile(player, world);
            ent.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
            world.func_217376_c((Entity)ent);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        list.add((ITextComponent)new TranslationTextComponent("pe.evertide.tooltip1", new Object[]{ClientKeyHelper.getKeyName(PEKeybind.FIRE_PROJECTILE)}));
        list.add((ITextComponent)new TranslationTextComponent("pe.evertide.tooltip2", new Object[0]));
        list.add((ITextComponent)new TranslationTextComponent("pe.evertide.tooltip3", new Object[0]));
        list.add((ITextComponent)new TranslationTextComponent("pe.evertide.tooltip4", new Object[0]));
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        TileEntity te;
        if (!world.field_72995_K && (Integer)ProjectEConfig.server.cooldown.pedestal.evertide.get() != -1 && (te = world.func_175625_s(pos)) instanceof DMPedestalTile) {
            DMPedestalTile tile = (DMPedestalTile)te;
            if (tile.getActivityCooldown() == 0) {
                int i = (300 + world.field_73012_v.nextInt(600)) * 20;
                world.func_72912_H().func_76080_g(i);
                world.func_72912_H().func_76090_f(i);
                world.func_72912_H().func_76084_b(true);
                tile.setActivityCooldown((Integer)ProjectEConfig.server.cooldown.pedestal.evertide.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if ((Integer)ProjectEConfig.server.cooldown.pedestal.evertide.get() != -1) {
            list.add(new TranslationTextComponent("pe.evertide.pedestal1", new Object[0]).func_211708_a(TextFormatting.BLUE));
            list.add(new TranslationTextComponent("pe.evertide.pedestal2", new Object[]{MathUtils.tickToSecFormatted((Integer)ProjectEConfig.server.cooldown.pedestal.evertide.get())}).func_211708_a(TextFormatting.BLUE));
        }
        return list;
    }

    private static class InfiniteFluidHandler
    extends BasicItemCapability<IFluidHandlerItem>
    implements IFluidHandlerItem {
        private InfiniteFluidHandler() {
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.getStack();
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? new FluidStack((Fluid)Fluids.field_204546_a, Integer.MAX_VALUE) : FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? Integer.MAX_VALUE : 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return stack.getFluid().func_207185_a(FluidTags.field_206959_a);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid().func_207185_a(FluidTags.field_206959_a)) {
                return resource.getAmount();
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid().func_207185_a(FluidTags.field_206959_a)) {
                return resource;
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)Fluids.field_204546_a, maxDrain);
        }

        @Override
        public Capability<IFluidHandlerItem> getCapability() {
            return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }
    }
}

