/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IModeChanger;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public interface IItemMode
extends IModeChanger {
    public String[] getModeTranslationKeys();

    default public byte getModeCount() {
        return (byte)this.getModeTranslationKeys().length;
    }

    default public String getModeTranslationKey(ItemStack stack) {
        String[] translationKeys = this.getModeTranslationKeys();
        byte mode = this.getMode(stack);
        if (mode < 0 || mode >= translationKeys.length) {
            return "pe.item.mode.invalid";
        }
        return translationKeys[mode];
    }

    @Override
    default public byte getMode(@Nonnull ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74771_c("Mode") : (byte)0;
    }

    @Override
    default public boolean changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, Hand hand) {
        byte numModes = this.getModeCount();
        if (numModes < 2) {
            return false;
        }
        stack.func_196082_o().func_74774_a("Mode", (byte)((this.getMode(stack) + 1) % numModes));
        TranslationTextComponent modeName = new TranslationTextComponent(this.getModeTranslationKey(stack), new Object[0]);
        player.func_145747_a((ITextComponent)new TranslationTextComponent("pe.item.mode_switch", new Object[]{modeName}));
        return true;
    }

    default public ITextComponent getToolTip(ItemStack stack) {
        return new TranslationTextComponent("pe.item.mode", new Object[0]).func_150258_a(": ").func_150257_a(new TranslationTextComponent(this.getModeTranslationKey(stack), new Object[0]).func_211708_a(TextFormatting.AQUA));
    }
}

