/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.capability.EmcHolderItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public class KleinStar
extends ItemPE
implements IItemEmcHolder {
    public final EnumKleinTier tier;

    public KleinStar(Item.Properties props, EnumKleinTier tier) {
        super(props);
        this.tier = tier;
        this.addItemCapability(new EmcHolderItemCapabilityWrapper());
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        long starEmc = KleinStar.getEmc(stack);
        if (starEmc == 0L) {
            return 1.0;
        }
        return 1.0 - (double)starEmc / (double)EMCHelper.getKleinStarMaxEmc(stack);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && PECore.DEV_ENVIRONMENT) {
            KleinStar.setEmc(stack, EMCHelper.getKleinStarMaxEmc(stack));
            return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.PASS, (Object)stack);
    }

    @Override
    public long insertEmc(@Nonnull ItemStack stack, long toInsert, IEmcStorage.EmcAction action) {
        if (toInsert < 0L) {
            return this.extractEmc(stack, -toInsert, action);
        }
        long toAdd = Math.min(this.getNeededEmc(stack), toInsert);
        if (action.execute()) {
            ItemPE.addEmcToStack(stack, toAdd);
        }
        return toAdd;
    }

    @Override
    public long extractEmc(@Nonnull ItemStack stack, long toExtract, IEmcStorage.EmcAction action) {
        if (toExtract < 0L) {
            return this.insertEmc(stack, -toExtract, action);
        }
        long storedEmc = this.getStoredEmc(stack);
        long toRemove = Math.min(storedEmc, toExtract);
        if (action.execute()) {
            ItemPE.setEmc(stack, storedEmc - toRemove);
        }
        return toRemove;
    }

    @Override
    public long getStoredEmc(@Nonnull ItemStack stack) {
        return ItemPE.getEmc(stack);
    }

    @Override
    public long getMaximumEmc(@Nonnull ItemStack stack) {
        return EMCHelper.getKleinStarMaxEmc(stack);
    }

    public static enum EnumKleinTier {
        EIN("ein"),
        ZWEI("zwei"),
        DREI("drei"),
        VIER("vier"),
        SPHERE("sphere"),
        OMEGA("omega");

        public final String name;

        private EnumKleinTier(String name) {
            this.name = name;
        }
    }
}

