/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.AlchBagItemCapabilityWrapper;
import moze_intel.projecte.capability.AlchChestItemCapabilityWrapper;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.LazyOptionalHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class RepairTalisman
extends ItemPE
implements IAlchBagItem,
IAlchChestItem,
IPedestalItem {
    public RepairTalisman(Item.Properties props) {
        super(props);
        this.addItemCapability(new AlchBagItemCapabilityWrapper());
        this.addItemCapability(new AlchChestItemCapabilityWrapper());
        this.addItemCapability(new PedestalItemCapabilityWrapper());
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int par4, boolean par5) {
        if (world.field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        player.getCapability(InternalTimers.CAPABILITY).ifPresent(timers -> {
            timers.activateRepair();
            if (timers.canRepair()) {
                this.repairAllItems(player);
            }
        });
    }

    private void repairAllItems(PlayerEntity player) {
        player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> this.repairInv((IItemHandler)inv, player));
        IItemHandler curios = PlayerHelper.getCurios(player);
        if (curios != null) {
            this.repairInv(curios, player);
        }
    }

    private void repairInv(IItemHandler inv, PlayerEntity player) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack invStack = inv.getStackInSlot(i);
            if (invStack.func_190926_b() || invStack.getCapability(ProjectEAPI.MODE_CHANGER_ITEM_CAPABILITY).isPresent() || !invStack.isRepairable() || invStack == player.func_184582_a(EquipmentSlotType.MAINHAND) && player.field_82175_bq || !ItemHelper.isDamageable(invStack) || invStack.func_77952_i() <= 0) continue;
            invStack.func_196085_b(invStack.func_77952_i() - 1);
        }
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && (Integer)ProjectEConfig.server.cooldown.pedestal.repair.get() != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
            if (tile.getActivityCooldown() == 0) {
                world.func_217357_a(ServerPlayerEntity.class, tile.getEffectBounds()).forEach(this::repairAllItems);
                tile.setActivityCooldown((Integer)ProjectEConfig.server.cooldown.pedestal.repair.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if ((Integer)ProjectEConfig.server.cooldown.pedestal.repair.get() != -1) {
            list.add(new TranslationTextComponent("pe.repairtalisman.pedestal1", new Object[0]).func_211708_a(TextFormatting.BLUE));
            list.add(new TranslationTextComponent("pe.repairtalisman.pedestal2", new Object[]{MathUtils.tickToSecFormatted((Integer)ProjectEConfig.server.cooldown.pedestal.repair.get())}).func_211708_a(TextFormatting.BLUE));
        }
        return list;
    }

    @Override
    public void updateInAlchChest(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof AlchChestTile)) {
            return;
        }
        AlchChestTile tile = (AlchChestTile)te;
        CompoundNBT nbt = stack.func_196082_o();
        byte coolDown = nbt.func_74771_c("Cooldown");
        if (coolDown > 0) {
            nbt.func_74774_a("Cooldown", (byte)(coolDown - 1));
        } else {
            boolean hasAction = false;
            Optional cap = LazyOptionalHelper.toOptional(tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY));
            if (cap.isPresent()) {
                IItemHandler inv = (IItemHandler)cap.get();
                for (int i = 0; i < inv.getSlots(); ++i) {
                    ItemStack invStack = inv.getStackInSlot(i);
                    if (invStack.func_190926_b() || invStack.func_77973_b() instanceof PEToggleItem || !invStack.func_77973_b().isRepairable(invStack) || !ItemHelper.isDamageable(invStack) || invStack.func_77952_i() <= 0) continue;
                    invStack.func_196085_b(invStack.func_77952_i() - 1);
                    if (hasAction) continue;
                    hasAction = true;
                }
                if (hasAction) {
                    nbt.func_74774_a("Cooldown", (byte)19);
                    tile.func_70296_d();
                }
            }
        }
    }

    @Override
    public boolean updateInAlchBag(@Nonnull IItemHandler inv, @Nonnull PlayerEntity player, @Nonnull ItemStack stack) {
        if (player.func_130014_f_().field_72995_K) {
            return false;
        }
        CompoundNBT nbt = stack.func_196082_o();
        byte coolDown = nbt.func_74771_c("Cooldown");
        if (coolDown > 0) {
            nbt.func_74774_a("Cooldown", (byte)(coolDown - 1));
        } else {
            boolean hasAction = false;
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack invStack = inv.getStackInSlot(i);
                if (invStack.func_190926_b() || invStack.func_77973_b() instanceof PEToggleItem || !invStack.func_77973_b().isRepairable(invStack) || !ItemHelper.isDamageable(invStack) || invStack.func_77952_i() <= 0) continue;
                invStack.func_196085_b(invStack.func_77952_i() - 1);
                if (hasAction) continue;
                hasAction = true;
            }
            if (hasAction) {
                nbt.func_74774_a("Cooldown", (byte)19);
                return true;
            }
        }
        return false;
    }
}

