/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.items.armor.PEArmor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public abstract class GemArmorBase
extends PEArmor {
    public GemArmorBase(EquipmentSlotType armorType, Item.Properties props) {
        super(GemArmorMaterial.INSTANCE, armorType, props);
    }

    @Override
    protected String getNameForLocation() {
        return "gem";
    }

    @Override
    public float getFullSetBaseReduction() {
        return 0.9f;
    }

    @Override
    public float getMaxDamageAbsorb(EquipmentSlotType slot, DamageSource source) {
        if (source.func_94541_c()) {
            return 750.0f;
        }
        if (slot == EquipmentSlotType.FEET && source == DamageSource.field_76379_h) {
            return 15.0f / this.getPieceEffectiveness(slot);
        }
        if (slot == EquipmentSlotType.HEAD && source == DamageSource.field_76369_e) {
            return 15.0f / this.getPieceEffectiveness(slot);
        }
        if (source.func_76363_c()) {
            return 0.0f;
        }
        if (slot == EquipmentSlotType.HEAD || slot == EquipmentSlotType.FEET) {
            return 400.0f;
        }
        return 500.0f;
    }

    public static boolean hasAnyPiece(PlayerEntity player) {
        return player.field_71071_by.field_70460_b.stream().anyMatch(i -> !i.func_190926_b() && i.func_77973_b() instanceof GemArmorBase);
    }

    public static boolean hasFullSet(PlayerEntity player) {
        return player.field_71071_by.field_70460_b.stream().noneMatch(i -> i.func_190926_b() || !(i.func_77973_b() instanceof GemArmorBase));
    }

    private static class GemArmorMaterial
    implements IArmorMaterial {
        private static final GemArmorMaterial INSTANCE = new GemArmorMaterial();

        private GemArmorMaterial() {
        }

        public int func_200896_a(@Nonnull EquipmentSlotType slot) {
            return 0;
        }

        public int func_200902_b(@Nonnull EquipmentSlotType slot) {
            if (slot == EquipmentSlotType.FEET) {
                return 3;
            }
            if (slot == EquipmentSlotType.LEGS) {
                return 6;
            }
            if (slot == EquipmentSlotType.CHEST) {
                return 8;
            }
            if (slot == EquipmentSlotType.HEAD) {
                return 3;
            }
            return 0;
        }

        public int func_200900_a() {
            return 0;
        }

        @Nonnull
        public SoundEvent func_200899_b() {
            return SoundEvents.field_187716_o;
        }

        @Nonnull
        public Ingredient func_200898_c() {
            return Ingredient.field_193370_a;
        }

        @Nonnull
        public String func_200897_d() {
            return "gem_armor";
        }

        public float func_200901_e() {
            return 2.0f;
        }
    }
}

