/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import java.util.List;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GemHelmet
extends GemArmorBase {
    public GemHelmet(Item.Properties props) {
        super(EquipmentSlotType.HEAD, props);
    }

    public static boolean isNightVisionEnabled(ItemStack helm) {
        return helm.func_77942_o() && helm.func_77978_p().func_74764_b("NightVision") && helm.func_77978_p().func_74767_n("NightVision");
    }

    public static void toggleNightVision(ItemStack helm, PlayerEntity player) {
        boolean value;
        CompoundNBT helmetTag = helm.func_196082_o();
        if (helmetTag.func_74764_b("NightVision")) {
            helmetTag.func_74757_a("NightVision", !helmetTag.func_74767_n("NightVision"));
            value = helmetTag.func_74767_n("NightVision");
        } else {
            helmetTag.func_74757_a("NightVision", false);
            value = false;
        }
        player.func_145747_a(new TranslationTextComponent("pe.gem.nightvision_tooltip", new Object[0]).func_150258_a(" ").func_150257_a(new TranslationTextComponent(value ? "pe.gem.enabled" : "pe.gem.disabled", new Object[0]).func_211708_a(value ? TextFormatting.GREEN : TextFormatting.RED)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltips, ITooltipFlag flags) {
        tooltips.add((ITextComponent)new TranslationTextComponent("pe.gem.helm.lorename", new Object[0]));
        tooltips.add((ITextComponent)new TranslationTextComponent("pe.gem.nightvision.prompt", new Object[]{new StringTextComponent(Minecraft.func_71410_x().field_71474_y.field_74311_E.func_197978_k()), ClientKeyHelper.getKeyName(PEKeybind.ARMOR_TOGGLE)}));
        boolean enabled = GemHelmet.isNightVisionEnabled(stack);
        tooltips.add(new TranslationTextComponent("pe.gem.nightvision_tooltip", new Object[0]).func_150258_a(" ").func_150257_a(new TranslationTextComponent(enabled ? "pe.gem.enabled" : "pe.gem.disabled", new Object[0]).func_211708_a(enabled ? TextFormatting.GREEN : TextFormatting.RED)));
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (world.field_72995_K) {
            int z;
            int y;
            int x = (int)Math.floor(player.field_70165_t);
            BlockPos pos = new BlockPos(x, y = (int)(player.field_70163_u - player.func_70033_W()), z = (int)Math.floor(player.field_70161_v));
            Block b = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (b == Blocks.field_150355_j && world.func_175623_d(pos) && !player.func_70093_af()) {
                player.func_213317_d(player.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
                player.field_70143_R = 0.0f;
                player.field_70122_E = true;
            }
        } else {
            player.getCapability(InternalTimers.CAPABILITY).ifPresent(handler -> {
                handler.activateHeal();
                if (player.func_110143_aJ() < player.func_110138_aP() && handler.canHeal()) {
                    player.func_70691_i(2.0f);
                }
            });
            if (GemHelmet.isNightVisionEnabled(stack)) {
                player.func_195064_c(new EffectInstance(Effects.field_76439_r, 220, 0, true, false));
            } else {
                player.func_195063_d(Effects.field_76439_r);
            }
            if (player.func_70090_H()) {
                player.func_70050_g(300);
            }
        }
    }

    public void doZap(PlayerEntity player) {
        BlockPos strikePos;
        if (((Boolean)ProjectEConfig.server.difficulty.offensiveAbilities.get()).booleanValue() && (strikePos = PlayerHelper.getBlockLookingAt(player, 120.0)) != null) {
            ((ServerWorld)player.func_130014_f_()).func_217468_a(new LightningBoltEntity(player.func_130014_f_(), (double)strikePos.func_177958_n(), (double)strikePos.func_177956_o(), (double)strikePos.func_177952_p(), false));
        }
    }
}

