/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.AlchBagItemCapabilityWrapper;
import moze_intel.projecte.capability.AlchChestItemCapabilityWrapper;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlackHoleBand
extends PEToggleItem
implements IAlchBagItem,
IAlchChestItem,
IPedestalItem {
    public BlackHoleBand(Item.Properties props) {
        super(props);
        this.addItemCapability(new AlchBagItemCapabilityWrapper());
        this.addItemCapability(new AlchChestItemCapabilityWrapper());
        this.addItemCapability(new PedestalItemCapabilityWrapper());
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    private ActionResultType tryPickupFluid(World world, PlayerEntity player, ItemStack stack) {
        Fluid fluid;
        RayTraceResult rtr = BlackHoleBand.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (!(rtr instanceof BlockRayTraceResult)) {
            return ActionResultType.PASS;
        }
        BlockRayTraceResult brtr = (BlockRayTraceResult)rtr;
        BlockPos fluidPos = brtr.func_216350_a();
        BlockState state = world.func_180495_p(fluidPos);
        if (world.func_175660_a(player, fluidPos) && player.func_175151_a(fluidPos, brtr.func_216354_b(), stack) && state.func_177230_c() instanceof IBucketPickupHandler && (fluid = ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)world, fluidPos, state)) != Fluids.field_204541_a) {
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, fluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        if (this.tryPickupFluid(world, player, player.func_184586_b(hand)) != ActionResultType.SUCCESS) {
            this.changeMode(player, player.func_184586_b(hand), hand);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void func_77663_a(ItemStack stack, @Nonnull World world, @Nonnull Entity entity, int slot, boolean held) {
        if (entity instanceof PlayerEntity && stack.func_77942_o() && stack.func_77978_p().func_74767_n("Active")) {
            PlayerEntity player = (PlayerEntity)entity;
            AxisAlignedBB bBox = player.func_174813_aQ().func_186662_g(7.0);
            List itemList = world.func_217357_a(ItemEntity.class, bBox);
            for (ItemEntity item : itemList) {
                if (ItemHelper.simulateFit((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, item.func_92059_d()) >= item.func_92059_d().func_190916_E()) continue;
                WorldHelper.gravitateEntityTowards((Entity)item, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
        }
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
        if (tile != null) {
            List list = world.func_217357_a(ItemEntity.class, tile.getEffectBounds());
            for (ItemEntity item : list) {
                WorldHelper.gravitateEntityTowards((Entity)item, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                if (world.field_72995_K || !(item.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < 1.21) || !item.func_70089_S()) continue;
                this.suckDumpItem(item, tile);
            }
        }
    }

    private void suckDumpItem(ItemEntity item, DMPedestalTile tile) {
        World world = tile.func_145831_w();
        for (Direction dir : Direction.values()) {
            TileEntity candidate = world.func_175625_s(tile.func_174877_v().func_177972_a(dir));
            if (candidate == null) continue;
            IItemHandler inv = WorldHelper.getItemHandler(candidate, dir);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)item.func_92059_d(), (boolean)false);
            if (result.func_190926_b()) {
                item.func_70106_y();
                return;
            }
            item.func_92058_a(result);
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        return Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("pe.bhb.pedestal1", new Object[0]).func_211708_a(TextFormatting.BLUE), new TranslationTextComponent("pe.bhb.pedestal2", new Object[0]).func_211708_a(TextFormatting.BLUE)});
    }

    @Override
    public void updateInAlchChest(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof AlchChestTile)) {
            return;
        }
        AlchChestTile tile = (AlchChestTile)te;
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Active")) {
            BlockPos tilePos = tile.func_174877_v();
            int tileX = tilePos.func_177958_n();
            int tileY = tilePos.func_177956_o();
            int tileZ = tilePos.func_177952_p();
            AxisAlignedBB aabb = new AxisAlignedBB((double)(tileX - 5), (double)(tileY - 5), (double)(tileZ - 5), (double)(tileX + 5), (double)(tileY + 5), (double)(tileZ + 5));
            double centeredX = (double)tileX + 0.5;
            double centeredY = (double)tileY + 0.5;
            double centeredZ = (double)tileZ + 0.5;
            for (ItemEntity e : tile.func_145831_w().func_217357_a(ItemEntity.class, aabb)) {
                WorldHelper.gravitateEntityTowards((Entity)e, centeredX, centeredY, centeredZ);
                if (e.func_130014_f_().field_72995_K || !e.func_70089_S() || !(e.func_70092_e(centeredX, centeredY, centeredZ) < 1.21)) continue;
                tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
                    ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)e.func_92059_d(), (boolean)false);
                    if (!result.func_190926_b()) {
                        e.func_92058_a(result);
                    } else {
                        e.func_70106_y();
                    }
                });
            }
        }
    }

    @Override
    public boolean updateInAlchBag(@Nonnull IItemHandler inv, @Nonnull PlayerEntity player, @Nonnull ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Active")) {
            for (ItemEntity e : player.func_130014_f_().func_217357_a(ItemEntity.class, player.func_174813_aQ().func_186662_g(5.0))) {
                WorldHelper.gravitateEntityTowards((Entity)e, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
        }
        return false;
    }
}

