/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class HarvestGoddess
extends PEToggleItem
implements IPedestalItem {
    public HarvestGoddess(Item.Properties props) {
        super(props);
        this.addItemCapability(new PedestalItemCapabilityWrapper());
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int slot, boolean held) {
        if (world.field_72995_K || slot > 8 || !(entity instanceof PlayerEntity)) {
            return;
        }
        super.func_77663_a(stack, world, entity, slot, held);
        PlayerEntity player = (PlayerEntity)entity;
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74767_n("Active")) {
            long storedEmc = HarvestGoddess.getEmc(stack);
            if (storedEmc == 0L && !HarvestGoddess.consumeFuel(player, stack, 64L, true)) {
                nbt.func_74757_a("Active", false);
            } else {
                WorldHelper.growNearbyRandomly(true, world, new BlockPos((Entity)player), player);
                HarvestGoddess.removeEmc(stack, EMCHelper.removeFractionalEMC(stack, 0.32f));
            }
        } else {
            WorldHelper.growNearbyRandomly(false, world, new BlockPos((Entity)player), player);
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        if (world.field_72995_K || !player.func_175151_a(ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_195996_i())) {
            return ActionResultType.FAIL;
        }
        if (player.func_70093_af()) {
            Object[] obj = this.getStackFromInventory((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, Items.field_196106_bc, 4);
            if (obj == null) {
                return ActionResultType.FAIL;
            }
            ItemStack boneMeal = (ItemStack)obj[1];
            if (!boneMeal.func_190926_b() && this.useBoneMeal(world, ctx.func_195995_a())) {
                player.field_71071_by.func_70298_a(((Integer)obj[0]).intValue(), 4);
                player.field_71069_bz.func_75142_b();
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return this.plantSeeds(world, player, ctx.func_195995_a()) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    private boolean useBoneMeal(World world, BlockPos pos) {
        boolean result = false;
        for (BlockPos currentPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-15, 0, -15), (BlockPos)pos.func_177982_a(15, 0, 15))) {
            IGrowable growable;
            BlockState state = world.func_180495_p(currentPos);
            Block crop = state.func_177230_c();
            if (!(crop instanceof IGrowable) || !(growable = (IGrowable)crop).func_180670_a(world, world.field_73012_v, currentPos, state)) continue;
            if (!result) {
                result = true;
            }
            growable.func_176474_b(world, world.field_73012_v, currentPos.func_185334_h(), state);
        }
        return result;
    }

    private boolean plantSeeds(World world, PlayerEntity player, BlockPos pos) {
        List<StackWithSlot> seeds = this.getAllSeeds((NonNullList<ItemStack>)player.field_71071_by.field_70462_a);
        if (seeds.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (BlockPos currentPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-8, 0, -8), (BlockPos)pos.func_177982_a(8, 0, 8))) {
            if (world.func_175623_d(currentPos)) continue;
            BlockState state = world.func_180495_p(currentPos);
            for (int i = 0; i < seeds.size(); ++i) {
                StackWithSlot s = seeds.get(i);
                IPlantable plant = s.stack.func_77973_b() instanceof IPlantable ? (IPlantable)s.stack.func_77973_b() : (IPlantable)Block.func_149634_a((Item)s.stack.func_77973_b());
                currentPos = currentPos.func_185334_h();
                if (!state.func_177230_c().canSustainPlant(state, (IBlockReader)world, currentPos, Direction.UP, plant) || !world.func_175623_d(currentPos.func_177984_a())) continue;
                world.func_175656_a(currentPos.func_177984_a(), plant.getPlant((IBlockReader)world, currentPos.func_177984_a()));
                player.field_71071_by.func_70298_a(s.slot, 1);
                player.field_71069_bz.func_75142_b();
                s.stack.func_190918_g(1);
                if (s.stack.func_190926_b()) {
                    seeds.remove(i);
                }
                if (result) continue;
                result = true;
            }
        }
        return result;
    }

    private List<StackWithSlot> getAllSeeds(NonNullList<ItemStack> inv) {
        ArrayList<StackWithSlot> result = new ArrayList<StackWithSlot>();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof IPlantable) {
                result.add(new StackWithSlot(stack, i));
                continue;
            }
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (!(block instanceof IPlantable)) continue;
            result.add(new StackWithSlot(stack, i));
        }
        return result;
    }

    private Object[] getStackFromInventory(NonNullList<ItemStack> inv, Item item, int minAmount) {
        Object[] obj = new Object[2];
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            if (stack.func_190926_b() || stack.func_190916_E() < minAmount || stack.func_77973_b() != item) continue;
            obj[0] = i;
            obj[1] = stack;
            return obj;
        }
        return null;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && (Integer)ProjectEConfig.server.cooldown.pedestal.harvest.get() != -1) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof DMPedestalTile)) {
                return;
            }
            DMPedestalTile tile = (DMPedestalTile)te;
            if (tile.getActivityCooldown() == 0) {
                WorldHelper.growNearbyRandomly(true, world, pos, null);
                tile.setActivityCooldown((Integer)ProjectEConfig.server.cooldown.pedestal.harvest.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if ((Integer)ProjectEConfig.server.cooldown.pedestal.harvest.get() != -1) {
            list.add(new TranslationTextComponent("pe.harvestgod.pedestal1", new Object[0]).func_211708_a(TextFormatting.BLUE));
            list.add(new TranslationTextComponent("pe.harvestgod.pedestal2", new Object[0]).func_211708_a(TextFormatting.BLUE));
            list.add(new TranslationTextComponent("pe.harvestgod.pedestal3", new Object[]{MathUtils.tickToSecFormatted((Integer)ProjectEConfig.server.cooldown.pedestal.harvest.get())}).func_211708_a(TextFormatting.BLUE));
        }
        return list;
    }

    private static class StackWithSlot {
        public final int slot;
        public final ItemStack stack;

        public StackWithSlot(ItemStack stack, int slot) {
            this.stack = stack.func_77946_l();
            this.slot = slot;
        }
    }
}

