/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class LifeStone
extends PEToggleItem
implements IPedestalItem {
    public LifeStone(Item.Properties props) {
        super(props);
        this.addItemCapability(new PedestalItemCapabilityWrapper());
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int slot, boolean held) {
        if (world.field_72995_K || slot > 8 || !(entity instanceof PlayerEntity)) {
            return;
        }
        super.func_77663_a(stack, world, entity, slot, held);
        PlayerEntity player = (PlayerEntity)entity;
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74767_n("Active")) {
            if (!LifeStone.consumeFuel(player, stack, 128L, false)) {
                nbt.func_74757_a("Active", false);
            } else {
                player.getCapability(InternalTimers.CAPABILITY, null).ifPresent(timers -> {
                    timers.activateFeed();
                    if (player.func_71024_bL().func_75121_c() && timers.canFeed()) {
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        player.func_71024_bL().func_75122_a(2, 10.0f);
                        LifeStone.removeEmc(stack, 64L);
                    }
                    timers.activateHeal();
                    if (player.func_110143_aJ() < player.func_110138_aP() && timers.canHeal()) {
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        player.func_70691_i(2.0f);
                        LifeStone.removeEmc(stack, 64L);
                    }
                });
            }
        }
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && (Integer)ProjectEConfig.server.cooldown.pedestal.life.get() != -1) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof DMPedestalTile)) {
                return;
            }
            DMPedestalTile tile = (DMPedestalTile)te;
            if (tile.getActivityCooldown() == 0) {
                List players = world.func_217357_a(ServerPlayerEntity.class, tile.getEffectBounds());
                for (ServerPlayerEntity player : players) {
                    if (player.func_110143_aJ() < player.func_110138_aP()) {
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        player.func_70691_i(1.0f);
                    }
                    if (!player.func_71024_bL().func_75121_c()) continue;
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    player.func_71024_bL().func_75122_a(1, 1.0f);
                }
                tile.setActivityCooldown((Integer)ProjectEConfig.server.cooldown.pedestal.life.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if ((Integer)ProjectEConfig.server.cooldown.pedestal.life.get() != -1) {
            list.add(new TranslationTextComponent("pe.life.pedestal1", new Object[0]).func_211708_a(TextFormatting.BLUE));
            list.add(new TranslationTextComponent("pe.life.pedestal2", new Object[]{MathUtils.tickToSecFormatted((Integer)ProjectEConfig.server.cooldown.pedestal.life.get())}).func_211708_a(TextFormatting.BLUE));
        }
        return list;
    }
}

