/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MindStone
extends PEToggleItem
implements IPedestalItem {
    private static final int TRANSFER_RATE = 50;

    public MindStone(Item.Properties props) {
        super(props);
        this.addItemCapability(new PedestalItemCapabilityWrapper());
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int slot, boolean held) {
        if (world.field_72995_K || slot > 8 || !(entity instanceof PlayerEntity)) {
            return;
        }
        super.func_77663_a(stack, world, entity, slot, held);
        PlayerEntity player = (PlayerEntity)entity;
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Active") && this.getXP(player) > 0) {
            int toAdd = Math.min(this.getXP(player), 50);
            this.addStoredXP(stack, toAdd);
            this.removeXP(player, 50);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        int toAdd;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && !stack.func_196082_o().func_74767_n("Active") && this.getStoredXP(stack) != 0 && (toAdd = this.removeStoredXP(stack, 50)) > 0) {
            this.addXP(player, toAdd);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        if (stack.func_77978_p() != null) {
            tooltip.add(new TranslationTextComponent("pe.misc.storedxp_tooltip", new Object[0]).func_211708_a(TextFormatting.DARK_GREEN).func_150258_a(" ").func_150257_a(new StringTextComponent(String.format("%,d", this.getStoredXP(stack))).func_211708_a(TextFormatting.GREEN)));
        }
    }

    private void removeXP(PlayerEntity player, int amount) {
        int experiencetotal = this.getXP(player) - amount;
        if (experiencetotal < 0) {
            player.field_71067_cb = 0;
            player.field_71068_ca = 0;
            player.field_71106_cc = 0.0f;
        } else {
            player.field_71067_cb = experiencetotal;
            player.field_71068_ca = this.getLvlForXP(experiencetotal);
            player.field_71106_cc = (float)(experiencetotal - this.getXPForLvl(player.field_71068_ca)) / (float)player.func_71050_bK();
        }
    }

    private void addXP(PlayerEntity player, int amount) {
        int experiencetotal;
        player.field_71067_cb = experiencetotal = this.getXP(player) + amount;
        player.field_71068_ca = this.getLvlForXP(experiencetotal);
        player.field_71106_cc = (float)(experiencetotal - this.getXPForLvl(player.field_71068_ca)) / (float)player.func_71050_bK();
    }

    private int getXP(PlayerEntity player) {
        return (int)((float)this.getXPForLvl(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    private int getXPForLvl(int level) {
        if (level < 0) {
            return Integer.MAX_VALUE;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0);
        }
        return (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0);
    }

    private int getLvlForXP(int totalXP) {
        int result = 0;
        while (this.getXPForLvl(result) <= totalXP) {
            ++result;
        }
        return --result;
    }

    private int getStoredXP(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74762_e("StoredXP") : 0;
    }

    private void setStoredXP(ItemStack stack, int XP) {
        stack.func_196082_o().func_74768_a("StoredXP", XP);
    }

    private void addStoredXP(ItemStack stack, int XP) {
        long result = (long)this.getStoredXP(stack) + (long)XP;
        if (result > Integer.MAX_VALUE) {
            result = Integer.MAX_VALUE;
        }
        this.setStoredXP(stack, (int)result);
    }

    private int removeStoredXP(ItemStack stack, int XP) {
        int returnResult;
        int result;
        int currentXP = this.getStoredXP(stack);
        if (currentXP < XP) {
            result = 0;
            returnResult = currentXP;
        } else {
            result = currentXP - XP;
            returnResult = XP;
        }
        this.setStoredXP(stack, result);
        return returnResult;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof DMPedestalTile)) {
            return;
        }
        DMPedestalTile tile = (DMPedestalTile)te;
        List orbs = world.func_217357_a(ExperienceOrbEntity.class, tile.getEffectBounds());
        for (ExperienceOrbEntity orb : orbs) {
            WorldHelper.gravitateEntityTowards((Entity)orb, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            if (world.field_72995_K || !(orb.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < 1.21)) continue;
            this.suckXP(orb, tile.getInventory().getStackInSlot(0));
        }
    }

    private void suckXP(ExperienceOrbEntity orb, ItemStack mindStone) {
        long l = this.getStoredXP(mindStone);
        if (l + (long)orb.field_70530_e > Integer.MAX_VALUE) {
            orb.field_70530_e = (int)(l + (long)orb.field_70530_e - Integer.MAX_VALUE);
            this.setStoredXP(mindStone, Integer.MAX_VALUE);
        } else {
            this.addStoredXP(mindStone, orb.field_70530_e);
            orb.func_70106_y();
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        return Lists.newArrayList((Iterable)new TranslationTextComponent("pe.mind.pedestal1", new Object[0]));
    }
}

