/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SWRG
extends ItemPE
implements IPedestalItem,
IFlightProvider,
IProjectileShooter {
    public SWRG(Item.Properties props) {
        super(props);
        this.func_185043_a(new ResourceLocation("projecte", "mode"), MODE_GETTER);
        this.addItemCapability(new PedestalItemCapabilityWrapper());
        this.addItemCapability(new ProjectileShooterItemCapabilityWrapper());
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    private void tick(ItemStack stack, PlayerEntity player) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74762_e("Mode") > 1) {
            WorldHelper.repelEntitiesInAABBFromPoint(player.func_130014_f_(), player.func_174813_aQ().func_186662_g(5.0), player.field_70165_t, player.field_70163_u, player.field_70161_v, true);
        }
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
        if (SWRG.getEmc(stack) == 0L && !SWRG.consumeFuel(player, stack, 64L, false)) {
            if (nbt.func_74762_e("Mode") > 0) {
                this.changeMode(player, stack, 0);
            }
            if (playerMP.field_71075_bZ.field_75101_c) {
                playerMP.getCapability(InternalAbilities.CAPABILITY).ifPresent(InternalAbilities::disableSwrgFlightOverride);
            }
            return;
        }
        if (!playerMP.field_71075_bZ.field_75101_c) {
            playerMP.getCapability(InternalAbilities.CAPABILITY).ifPresent(InternalAbilities::enableSwrgFlightOverride);
        }
        if (playerMP.field_71075_bZ.field_75100_b) {
            if (!this.isFlyingEnabled(stack)) {
                this.changeMode(player, stack, nbt.func_74762_e("Mode") == 0 ? 1 : 3);
            }
        } else if (this.isFlyingEnabled(stack)) {
            this.changeMode(player, stack, nbt.func_74762_e("Mode") == 1 ? 0 : 2);
        }
        float toRemove = 0.0f;
        if (playerMP.field_71075_bZ.field_75100_b) {
            toRemove = 0.32f;
        }
        if (nbt.func_74762_e("Mode") == 2) {
            toRemove = 0.32f;
        } else if (nbt.func_74762_e("Mode") == 3) {
            toRemove = 0.64f;
        }
        SWRG.removeEmc(stack, EMCHelper.removeFractionalEMC(stack, toRemove));
        playerMP.field_70143_R = 0.0f;
    }

    private boolean isFlyingEnabled(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("Mode") == 1 || stack.func_77978_p().func_74762_e("Mode") == 3;
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull Entity entity, int invSlot, boolean isHeldItem) {
        if (invSlot > 8 || !(entity instanceof PlayerEntity)) {
            return;
        }
        this.tick(stack, (PlayerEntity)entity);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            int newMode = 0;
            switch (stack.func_196082_o().func_74762_e("Mode")) {
                case 0: {
                    newMode = 2;
                    break;
                }
                case 1: {
                    newMode = 3;
                    break;
                }
                case 2: {
                    newMode = 0;
                    break;
                }
                case 3: {
                    newMode = 1;
                }
            }
            this.changeMode(player, stack, newMode);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
    }

    public void changeMode(PlayerEntity player, ItemStack stack, int mode) {
        CompoundNBT nbt = stack.func_196082_o();
        int oldMode = nbt.func_74762_e("Mode");
        if (mode == oldMode) {
            return;
        }
        nbt.func_74768_a("Mode", mode);
        if (player == null) {
            return;
        }
        if (mode == 0 || oldMode == 3) {
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.PLAYERS, 0.8f, 1.0f);
        } else if (oldMode == 0 || mode == 3) {
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.UNCHARGE, SoundCategory.PLAYERS, 0.8f, 1.0f);
        }
    }

    @Override
    public boolean canProvideFlight(ItemStack stack, ServerPlayerEntity player) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && (Integer)ProjectEConfig.server.cooldown.pedestal.swrg.get() != -1) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof DMPedestalTile)) {
                return;
            }
            DMPedestalTile tile = (DMPedestalTile)te;
            if (tile.getActivityCooldown() <= 0) {
                List list = world.func_217357_a(MobEntity.class, tile.getEffectBounds());
                for (MobEntity living : list) {
                    if (living instanceof TameableEntity && ((TameableEntity)living).func_70909_n()) continue;
                    ((ServerWorld)world).func_217468_a(new LightningBoltEntity(world, living.field_70165_t, living.field_70163_u, living.field_70161_v, false));
                }
                tile.setActivityCooldown((Integer)ProjectEConfig.server.cooldown.pedestal.swrg.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if ((Integer)ProjectEConfig.server.cooldown.pedestal.swrg.get() != -1) {
            list.add(new TranslationTextComponent("pe.swrg.pedestal1", new Object[0]).func_211708_a(TextFormatting.BLUE));
            list.add(new TranslationTextComponent("pe.swrg.pedestal2", new Object[]{MathUtils.tickToSecFormatted((Integer)ProjectEConfig.server.cooldown.pedestal.swrg.get())}).func_211708_a(TextFormatting.BLUE));
        }
        return list;
    }

    @Override
    public boolean shootProjectile(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, @Nullable Hand hand) {
        EntitySWRGProjectile projectile = new EntitySWRGProjectile(player, false, player.field_70170_p);
        projectile.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
        player.field_70170_p.func_217376_c((Entity)projectile);
        return true;
    }
}

