/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.ItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.utils.ToolHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PEHoe
extends HoeItem
implements IItemCharge {
    private final EnumMatterType matterType;
    private final int numCharges;

    public PEHoe(EnumMatterType matterType, int numCharges, Item.Properties props) {
        super((IItemTier)matterType, (float)matterType.getMatterTier(), props.addToolType(ToolHelper.TOOL_TYPE_HOE, matterType.func_200925_d()));
        this.matterType = matterType;
        this.numCharges = numCharges;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getChargePercent(stack);
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return ToolHelper.getDestroySpeed(super.func_150893_a(stack, state), this.matterType, this.getCharge(stack));
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return this.numCharges;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, new ChargeItemCapabilityWrapper());
    }

    public boolean func_150897_b(BlockState state) {
        if (state.getHarvestTool() == ToolHelper.TOOL_TYPE_HOE) {
            return this.func_200891_e().func_200925_d() >= state.getHarvestLevel();
        }
        return super.func_150897_b(state);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        return ToolHelper.tillHoeAOE(context, 0L);
    }
}

