/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.capability.ExtraFunctionItemCapabilityWrapper;
import moze_intel.projecte.capability.ModeChangerItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.tools.PETool;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.ToolHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.ToolType;

public class PEKatar
extends PETool
implements IItemMode,
IExtraFunction {
    private final String[] modeDesc = new String[]{"pe.katar.mode1", "pe.katar.mode2"};

    public PEKatar(EnumMatterType matterType, int numCharges, Item.Properties props) {
        super(matterType, 19.0f, -2.4f, numCharges, props.addToolType(ToolType.AXE, matterType.func_200925_d()).addToolType(ToolHelper.TOOL_TYPE_SHEARS, matterType.func_200925_d()).addToolType(ToolHelper.TOOL_TYPE_HOE, matterType.func_200925_d()).addToolType(ToolHelper.TOOL_TYPE_KATAR, matterType.func_200925_d()));
        this.addItemCapability(new ModeChangerItemCapabilityWrapper());
        this.addItemCapability(new ExtraFunctionItemCapabilityWrapper());
    }

    @Override
    public String[] getModeTranslationKeys() {
        return this.modeDesc;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        list.add(this.getToolTip(stack));
    }

    public boolean func_150897_b(BlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_196553_aF || block == Blocks.field_150488_af || block == Blocks.field_150473_bD;
    }

    @Override
    protected float getShortCutDestroySpeed(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        float destroySpeed = super.getShortCutDestroySpeed(stack, state);
        if (destroySpeed == 1.0f) {
            Material material = state.func_185904_a();
            if (material == Material.field_151575_d || material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_215713_z) {
                return this.field_77864_a;
            }
            if (state.func_203425_a(BlockTags.field_206952_E) || state.func_203425_a(BlockTags.field_199897_a)) {
                return this.field_77864_a;
            }
        }
        return destroySpeed;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(context.func_195995_a());
        return ToolHelper.performActions(AxeItem.field_203176_a.get(state.func_177230_c()) == null ? ActionResultType.PASS : ToolHelper.stripLogsAOE(context, 0L), () -> HoeItem.field_195973_b.get(state.func_177230_c()) == null ? ActionResultType.PASS : ToolHelper.tillHoeAOE(context, 0L), () -> {
            if (state.func_203425_a(BlockTags.field_200031_h)) {
                return ToolHelper.clearTagAOE(world, player, hand, 0L, (Tag<Block>)BlockTags.field_200031_h);
            }
            return ActionResultType.PASS;
        }, () -> {
            if (state.func_203425_a(BlockTags.field_206952_E)) {
                return ToolHelper.clearTagAOE(world, player, hand, 0L, (Tag<Block>)BlockTags.field_206952_E);
            }
            return ActionResultType.PASS;
        });
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull LivingEntity damaged, @Nonnull LivingEntity damager) {
        ToolHelper.attackWithCharge(stack, damaged, damager, 1.0f);
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        return ToolHelper.shearBlock(stack, pos, player) == ActionResultType.SUCCESS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        return ActionResult.newResult((ActionResultType)ToolHelper.shearEntityAOE(player, hand, 0L), (Object)player.func_184586_b(hand));
    }

    @Override
    public boolean doExtraFunction(@Nonnull ItemStack stack, @Nonnull PlayerEntity player, Hand hand) {
        if (player.func_184825_o(0.0f) == 1.0f) {
            ToolHelper.attackAOE(stack, player, this.getMode(stack) == 1, ((Double)ProjectEConfig.server.difficulty.katarDeathAura.get()).floatValue(), 0L, hand);
            PlayerHelper.resetCooldown(player);
            return true;
        }
        return false;
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, ItemStack stack) {
        return ToolHelper.addChargeAttributeModifier((Multimap<String, AttributeModifier>)super.getAttributeModifiers(slot, stack), slot, stack);
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        BlockPos pos;
        IShearable target;
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (entity instanceof IShearable && (target = (IShearable)entity).isShearable(stack, (IWorldReader)entity.field_70170_p, pos = entity.func_180425_c())) {
            List drops = target.onSheared(stack, (IWorld)entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
            Random rand = new Random();
            drops.forEach(d -> {
                ItemEntity ent = entity.func_70099_a(d, 1.0f);
                ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
            });
            return true;
        }
        return false;
    }
}

