/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.tools.PETool;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.ToolHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;

public class PEMorningStar
extends PETool
implements IItemMode {
    private final String[] modeDesc = new String[]{"pe.morningstar.mode1", "pe.morningstar.mode2", "pe.morningstar.mode3", "pe.morningstar.mode4"};

    public PEMorningStar(EnumMatterType matterType, int numCharges, Item.Properties props) {
        super(matterType, 16.0f, -3.0f, numCharges, props.addToolType(ToolType.PICKAXE, matterType.func_200925_d()).addToolType(ToolType.SHOVEL, matterType.func_200925_d()).addToolType(ToolHelper.TOOL_TYPE_HAMMER, matterType.func_200925_d()).addToolType(ToolHelper.TOOL_TYPE_MORNING_STAR, matterType.func_200925_d()));
    }

    @Override
    public String[] getModeTranslationKeys() {
        return this.modeDesc;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        list.add(this.getToolTip(stack));
    }

    public boolean func_150897_b(BlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150433_aE || block == Blocks.field_196604_cC) {
            return true;
        }
        Material material = state.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g;
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull LivingEntity damaged, @Nonnull LivingEntity damager) {
        ToolHelper.attackWithCharge(stack, damaged, damager, 1.0f);
        return true;
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity living) {
        ToolHelper.digBasedOnMode(stack, world, pos, living, Item::func_219968_a);
        return true;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction sideHit = context.func_196000_l();
        BlockState state = world.func_180495_p(pos);
        return ToolHelper.performActions(ToolHelper.tillShovelAOE(context, 0L), () -> {
            if (state.func_203425_a(Tags.Blocks.GRAVEL) || state.func_177230_c() == Blocks.field_150435_aG) {
                if (((Boolean)ProjectEConfig.server.items.pickaxeAoeVeinMining.get()).booleanValue()) {
                    return ToolHelper.digAOE(world, player, hand, pos, sideHit, false, 0L);
                }
                return ToolHelper.tryVeinMine(hand, player, pos, sideHit);
            }
            return ActionResultType.PASS;
        }, () -> {
            if (ItemHelper.isOre(state) && !((Boolean)ProjectEConfig.server.items.pickaxeAoeVeinMining.get()).booleanValue()) {
                return ToolHelper.tryVeinMine(hand, player, pos, sideHit);
            }
            return ActionResultType.PASS;
        }, () -> ToolHelper.digAOE(world, player, hand, pos, sideHit, !(state.func_177230_c() instanceof GrassBlock) && !state.func_203425_a(BlockTags.field_203436_u) && !state.func_203425_a(Tags.Blocks.DIRT), 0L));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (((Boolean)ProjectEConfig.server.items.pickaxeAoeVeinMining.get()).booleanValue()) {
            return ActionResult.newResult((ActionResultType)ToolHelper.mineOreVeinsInAOE(player, hand), (Object)stack);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.PASS, (Object)stack);
    }

    @Override
    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        if (ToolHelper.canMatterMine(this.matterType, state.func_177230_c())) {
            return 1200000.0f;
        }
        return super.func_150893_a(stack, state) + 48.0f;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, ItemStack stack) {
        return ToolHelper.addChargeAttributeModifier((Multimap<String, AttributeModifier>)super.getAttributeModifiers(slot, stack), slot, stack);
    }
}

