/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.ItemCapabilityWrapper;
import moze_intel.projecte.capability.ModeChangerItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.ToolHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.PickaxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PEPickaxe
extends PickaxeItem
implements IItemCharge,
IItemMode {
    private final EnumMatterType matterType;
    private final String[] modeDesc = new String[]{"pe.pick.mode1", "pe.pick.mode2", "pe.pick.mode3", "pe.pick.mode4"};
    private final int numCharges;

    public PEPickaxe(EnumMatterType matterType, int numCharges, Item.Properties props) {
        super((IItemTier)matterType, 4, -2.8f, props);
        this.matterType = matterType;
        this.numCharges = numCharges;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getChargePercent(stack);
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        if (ToolHelper.canMatterMine(this.matterType, state.func_177230_c())) {
            return 1200000.0f;
        }
        return ToolHelper.getDestroySpeed(super.func_150893_a(stack, state), this.matterType, this.getCharge(stack));
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return this.numCharges;
    }

    @Override
    public String[] getModeTranslationKeys() {
        return this.modeDesc;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        list.add(this.getToolTip(stack));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, new ChargeItemCapabilityWrapper(), new ModeChangerItemCapabilityWrapper());
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (((Boolean)ProjectEConfig.server.items.pickaxeAoeVeinMining.get()).booleanValue()) {
            return ActionResult.newResult((ActionResultType)ToolHelper.mineOreVeinsInAOE(player, hand), (Object)stack);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.PASS, (Object)stack);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null || ((Boolean)ProjectEConfig.server.items.pickaxeAoeVeinMining.get()).booleanValue()) {
            return ActionResultType.PASS;
        }
        BlockPos pos = context.func_195995_a();
        if (ItemHelper.isOre(context.func_195991_k().func_180495_p(pos))) {
            return ToolHelper.tryVeinMine(context.func_221531_n(), player, pos, context.func_196000_l());
        }
        return ActionResultType.PASS;
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity living) {
        ToolHelper.digBasedOnMode(stack, world, pos, living, Item::func_219968_a);
        return true;
    }
}

