/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.ItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.utils.ToolHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShearsItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PEShears
extends ShearsItem
implements IItemCharge {
    private final EnumMatterType matterType;
    private final int numCharges;

    public PEShears(EnumMatterType matterType, int numCharges, Item.Properties props) {
        super(props.addToolType(ToolHelper.TOOL_TYPE_SHEARS, matterType.func_200925_d()));
        this.matterType = matterType;
        this.numCharges = numCharges;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getChargePercent(stack);
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return ToolHelper.getDestroySpeed(super.func_150893_a(stack, state), this.matterType, this.getCharge(stack));
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return this.numCharges;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, new ChargeItemCapabilityWrapper());
    }

    public boolean func_150897_b(BlockState state) {
        if (state.getHarvestTool() == ToolHelper.TOOL_TYPE_SHEARS) {
            return this.matterType.func_200925_d() >= state.getHarvestLevel();
        }
        return super.func_150897_b(state);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        return ActionResult.newResult((ActionResultType)ToolHelper.shearEntityAOE(player, hand, 0L), (Object)player.func_184586_b(hand));
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        return ToolHelper.shearBlock(stack, pos, player) == ActionResultType.SUCCESS;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world;
        PlayerEntity player = context.func_195999_j();
        if (player != null && (world = context.func_195991_k()).func_180495_p(context.func_195995_a()).func_203425_a(BlockTags.field_206952_E)) {
            ToolHelper.clearTagAOE(world, player, context.func_221531_n(), 0L, (Tag<Block>)BlockTags.field_206952_E);
        }
        return ActionResultType.PASS;
    }
}

