/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.ItemCapability;
import moze_intel.projecte.capability.ItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.utils.ToolHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class PETool
extends ToolItem
implements IItemCharge {
    private final List<ItemCapability<?>> supportedCapabilities = new ArrayList();
    protected final EnumMatterType matterType;
    private final int numCharges;

    public PETool(EnumMatterType matterType, float damage, float attackSpeed, int numCharges, Item.Properties props) {
        super(damage, attackSpeed, (IItemTier)matterType, new HashSet(), props);
        this.matterType = matterType;
        this.numCharges = numCharges;
        this.addItemCapability(new ChargeItemCapabilityWrapper());
    }

    protected <TYPE> void addItemCapability(ItemCapability<TYPE> capability) {
        this.supportedCapabilities.add(capability);
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getChargePercent(stack);
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return ToolHelper.getDestroySpeed(this.getShortCutDestroySpeed(stack, state), this.matterType, this.getCharge(stack));
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return this.numCharges;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        if (this.supportedCapabilities.isEmpty()) {
            return super.initCapabilities(stack, nbt);
        }
        return new ItemCapabilityWrapper(stack, this.supportedCapabilities);
    }

    public boolean canHarvestBlock(@Nonnull ItemStack stack, BlockState state) {
        ToolType requiredTool = state.getHarvestTool();
        for (ToolType toolType : this.getToolTypes(stack)) {
            if (toolType != requiredTool) continue;
            return this.getHarvestLevel(stack, toolType, null, state) >= state.getHarvestLevel();
        }
        return super.canHarvestBlock(stack, state);
    }

    protected float getShortCutDestroySpeed(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return super.func_150893_a(stack, state);
    }
}

