/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import java.util.Optional;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.blocks.MatterFurnace;
import moze_intel.projecte.gameObjs.container.DMFurnaceContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.DropperTileEntity;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class DMFurnaceTile
extends TileEmc
implements INamedContainerProvider {
    private static final long EMC_CONSUMPTION = 2L;
    private final ItemStackHandler inputInventory = new TileEmc.StackHandler(this, this.getInvSize());
    private final ItemStackHandler outputInventory = new TileEmc.StackHandler(this, this.getInvSize());
    private final ItemStackHandler fuelInv = new TileEmc.StackHandler(this, 1);
    private final LazyOptional<IItemHandler> automationInput = LazyOptional.of(() -> new WrappedItemHandler((IItemHandlerModifiable)this.inputInventory, WrappedItemHandler.WriteMode.IN){

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return !DMFurnaceTile.this.getSmeltingResult(stack).func_190926_b() ? super.insertItem(slot, stack, simulate) : stack;
        }
    });
    private final LazyOptional<IItemHandler> automationFuel = LazyOptional.of(() -> new WrappedItemHandler((IItemHandlerModifiable)this.fuelInv, WrappedItemHandler.WriteMode.IN){

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return SlotPredicates.FURNACE_FUEL.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    });
    private final LazyOptional<IItemHandler> automationOutput = LazyOptional.of(() -> new WrappedItemHandler((IItemHandlerModifiable)this.outputInventory, WrappedItemHandler.WriteMode.OUT));
    private final LazyOptional<IItemHandler> automationSides = LazyOptional.of(() -> {
        IItemHandlerModifiable fuel = (IItemHandlerModifiable)this.automationFuel.orElseThrow(NullPointerException::new);
        IItemHandlerModifiable out = (IItemHandlerModifiable)this.automationOutput.orElseThrow(NullPointerException::new);
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{fuel, out});
    });
    private final LazyOptional<IItemHandler> joined = LazyOptional.of(() -> {
        IItemHandlerModifiable in = (IItemHandlerModifiable)this.automationInput.orElseThrow(NullPointerException::new);
        IItemHandlerModifiable fuel = (IItemHandlerModifiable)this.automationFuel.orElseThrow(NullPointerException::new);
        IItemHandlerModifiable out = (IItemHandlerModifiable)this.automationOutput.orElseThrow(NullPointerException::new);
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{in, fuel, out});
    });
    protected final int ticksBeforeSmelt;
    private final int efficiencyBonus;
    private final FurnaceTileEntity dummyFurnace = new FurnaceTileEntity();
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;
    private boolean outputEmpty = true;
    private boolean isCompacting;

    public DMFurnaceTile() {
        this(ObjHandler.DM_FURNACE_TILE, 10, 3);
    }

    protected DMFurnaceTile(TileEntityType<?> type, int ticksBeforeSmelt, int efficiencyBonus) {
        super(type, 64L);
        this.ticksBeforeSmelt = ticksBeforeSmelt;
        this.efficiencyBonus = efficiencyBonus;
    }

    @Override
    protected boolean canProvideEmc() {
        return false;
    }

    @Override
    protected long getEmcInsertLimit() {
        return 2L;
    }

    protected int getInvSize() {
        return 9;
    }

    protected float getOreDoubleChance() {
        return 0.5f;
    }

    public int getCookProgressScaled(int value) {
        return this.furnaceCookTime * value / this.ticksBeforeSmelt;
    }

    @Nonnull
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInv, @Nonnull PlayerEntity playerIn) {
        return new DMFurnaceContainer(windowId, playerInv, this);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(ObjHandler.dmFurnace.func_149739_a(), new Object[0]);
    }

    public void func_174878_a(@Nonnull BlockPos pos) {
        super.func_174878_a(pos);
        this.dummyFurnace.func_174878_a(pos);
    }

    public void func_145834_a(@Nonnull World world) {
        super.func_145834_a(world);
        this.dummyFurnace.func_145834_a(world);
    }

    public IItemHandler getFuel() {
        return this.fuelInv;
    }

    private ItemStack getFuelItem() {
        return this.fuelInv.getStackInSlot(0);
    }

    public IItemHandler getInput() {
        return this.inputInventory;
    }

    public IItemHandler getOutput() {
        return this.outputInventory;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.automationInput.invalidate();
        this.automationOutput.invalidate();
        this.automationFuel.invalidate();
        this.automationSides.invalidate();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.joined.cast();
            }
            switch (side) {
                case UP: {
                    return this.automationInput.cast();
                }
                case DOWN: {
                    return this.automationOutput.cast();
                }
            }
            return this.automationSides.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_73660_a() {
        boolean wasBurning = this.isBurning();
        boolean shouldSave = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.func_145831_w().field_72995_K) {
            this.pullFromInventories();
            ItemStack fuelItem = this.getFuelItem();
            if (this.canSmelt() && !fuelItem.func_190926_b()) {
                fuelItem.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).ifPresent(emcHolder -> {
                    long simulatedExtraction = emcHolder.extractEmc(fuelItem, 2L, IEmcStorage.EmcAction.SIMULATE);
                    if (simulatedExtraction == 2L) {
                        this.forceInsertEmc(emcHolder.extractEmc(fuelItem, simulatedExtraction, IEmcStorage.EmcAction.EXECUTE), IEmcStorage.EmcAction.EXECUTE);
                    }
                });
            }
            if (this.getStoredEmc() >= 2L) {
                this.furnaceBurnTime = 1;
                this.forceExtractEmc(2L, IEmcStorage.EmcAction.EXECUTE);
            }
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = this.getItemBurnTime(fuelItem);
                if (this.isBurning()) {
                    shouldSave = true;
                    if (!fuelItem.func_190926_b()) {
                        ItemStack copy = fuelItem.func_77946_l();
                        fuelItem.func_190918_g(1);
                        if (fuelItem.func_190926_b()) {
                            this.fuelInv.setStackInSlot(0, copy.func_77973_b().getContainerItem(copy));
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == this.ticksBeforeSmelt) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    shouldSave = true;
                }
            }
            if (wasBurning != this.isBurning()) {
                shouldSave = true;
                BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                if (state.func_177230_c() instanceof MatterFurnace) {
                    this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a((IProperty)MatterFurnace.field_220091_b, (Comparable)Boolean.valueOf(this.isBurning())));
                }
            }
            if (shouldSave) {
                this.func_70296_d();
            }
            this.pushToInventories();
        }
    }

    public void func_70296_d() {
        if (!this.isCompacting) {
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.isCompacting = true;
                ItemHelper.compactInventory((IItemHandlerModifiable)this.inputInventory);
                this.outputEmpty = ItemHelper.compactInventory((IItemHandlerModifiable)this.outputInventory);
                this.isCompacting = false;
            }
            super.func_70296_d();
        }
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private void pullFromInventories() {
        TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177984_a());
        if (tile == null || tile instanceof HopperTileEntity || tile instanceof DropperTileEntity) {
            return;
        }
        IItemHandler handler = WorldHelper.getItemHandler(tile, Direction.DOWN);
        if (handler == null) {
            return;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extractTest = handler.extractItem(i, Integer.MAX_VALUE, true);
            if (extractTest.func_190926_b()) continue;
            ItemStackHandler targetInv = extractTest.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).isPresent() || AbstractFurnaceTileEntity.func_213991_b((ItemStack)extractTest) ? this.fuelInv : this.inputInventory;
            this.transferItem((IItemHandler)targetInv, i, extractTest, handler);
        }
    }

    private void pushToInventories() {
        if (this.outputEmpty) {
            return;
        }
        TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177977_b());
        if (tile == null || tile instanceof HopperTileEntity) {
            return;
        }
        IItemHandler targetInv = WorldHelper.getItemHandler(tile, Direction.UP);
        if (targetInv == null) {
            return;
        }
        for (int i = 0; i < this.outputInventory.getSlots(); ++i) {
            ItemStack extractTest = this.outputInventory.extractItem(i, Integer.MAX_VALUE, true);
            if (extractTest.func_190926_b()) continue;
            this.transferItem(targetInv, i, extractTest, (IItemHandler)this.outputInventory);
        }
    }

    private void transferItem(IItemHandler targetInv, int i, ItemStack extractTest, IItemHandler outputInventory) {
        ItemStack remainderTest = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)extractTest, (boolean)true);
        int successfullyTransferred = extractTest.func_190916_E() - remainderTest.func_190916_E();
        if (successfullyTransferred > 0) {
            ItemStack toInsert = outputInventory.extractItem(i, successfullyTransferred, false);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)toInsert, (boolean)false);
            assert (result.func_190926_b());
        }
    }

    public ItemStack getSmeltingResult(ItemStack in) {
        this.dummyFurnace.func_70299_a(0, in);
        Optional recipe = this.func_145831_w().func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)this.dummyFurnace, this.field_145850_b);
        this.dummyFurnace.func_174888_l();
        return recipe.map(IRecipe::func_77571_b).orElse(ItemStack.field_190927_a);
    }

    private void smeltItem() {
        ItemStack toSmelt = this.inputInventory.getStackInSlot(0);
        ItemStack smeltResult = this.getSmeltingResult(toSmelt).func_77946_l();
        if (this.field_145850_b.field_73012_v.nextFloat() < this.getOreDoubleChance() && ItemHelper.isOre(toSmelt.func_77973_b())) {
            smeltResult.func_190917_f(smeltResult.func_190916_E());
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInventory, (ItemStack)smeltResult, (boolean)false);
        toSmelt.func_190918_g(1);
    }

    protected boolean canSmelt() {
        ItemStack toSmelt = this.inputInventory.getStackInSlot(0);
        if (toSmelt.func_190926_b()) {
            return false;
        }
        ItemStack smeltResult = this.getSmeltingResult(toSmelt);
        if (smeltResult.func_190926_b()) {
            return false;
        }
        ItemStack currentSmelted = this.outputInventory.getStackInSlot(this.outputInventory.getSlots() - 1);
        if (currentSmelted.func_190926_b()) {
            return true;
        }
        if (!smeltResult.func_77969_a(currentSmelted)) {
            return false;
        }
        int result = currentSmelted.func_190916_E() + smeltResult.func_190916_E();
        return result <= currentSmelted.func_77976_d();
    }

    private int getItemBurnTime(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack) * this.ticksBeforeSmelt / 200 * this.efficiencyBonus;
    }

    public int getBurnTimeRemainingScaled(int value) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.ticksBeforeSmelt;
        }
        return this.furnaceBurnTime * value / this.currentItemBurnTime;
    }

    @Override
    public void func_145839_a(@Nonnull CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.furnaceBurnTime = nbt.func_74765_d("BurnTime");
        this.furnaceCookTime = nbt.func_74765_d("CookTime");
        this.inputInventory.deserializeNBT(nbt.func_74775_l("Input"));
        this.outputInventory.deserializeNBT(nbt.func_74775_l("Output"));
        this.fuelInv.deserializeNBT(nbt.func_74775_l("Fuel"));
        this.currentItemBurnTime = this.getItemBurnTime(this.getFuelItem());
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        nbt.func_74777_a("CookTime", (short)this.furnaceCookTime);
        nbt.func_218657_a("Input", (INBT)this.inputInventory.serializeNBT());
        nbt.func_218657_a("Output", (INBT)this.outputInventory.serializeNBT());
        nbt.func_218657_a("Fuel", (INBT)this.fuelInv.serializeNBT());
        return nbt;
    }
}

