/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.handlers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.config.ProjectEConfig;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class InternalTimers {
    @CapabilityInject(value=InternalTimers.class)
    public static Capability<InternalTimers> CAPABILITY = null;
    public static final ResourceLocation NAME = new ResourceLocation("projecte", "internal_timers");
    private final Timer repair = new Timer();
    private final Timer heal = new Timer();
    private final Timer feed = new Timer();

    public void tick() {
        this.repair.tick();
        this.heal.tick();
        this.feed.tick();
    }

    public void activateRepair() {
        this.repair.shouldUpdate = (Integer)ProjectEConfig.server.cooldown.player.repair.get() != -1;
    }

    public void activateHeal() {
        this.heal.shouldUpdate = (Integer)ProjectEConfig.server.cooldown.player.heal.get() != -1;
    }

    public void activateFeed() {
        this.feed.shouldUpdate = (Integer)ProjectEConfig.server.cooldown.player.feed.get() != -1;
    }

    public boolean canRepair() {
        if (this.repair.tickCount == 0) {
            this.repair.tickCount = (Integer)ProjectEConfig.server.cooldown.player.repair.get();
            this.repair.shouldUpdate = false;
            return true;
        }
        return false;
    }

    public boolean canHeal() {
        if (this.heal.tickCount == 0) {
            this.heal.tickCount = (Integer)ProjectEConfig.server.cooldown.player.heal.get();
            this.heal.shouldUpdate = false;
            return true;
        }
        return false;
    }

    public boolean canFeed() {
        if (this.feed.tickCount == 0) {
            this.feed.tickCount = (Integer)ProjectEConfig.server.cooldown.player.feed.get();
            this.feed.shouldUpdate = false;
            return true;
        }
        return false;
    }

    private static class Timer {
        private int tickCount = 0;
        private boolean shouldUpdate = false;

        private Timer() {
        }

        private void tick() {
            if (this.shouldUpdate) {
                if (this.tickCount > 0) {
                    --this.tickCount;
                }
                this.shouldUpdate = false;
            }
        }
    }

    public static class Provider
    implements ICapabilityProvider {
        private final LazyOptional<InternalTimers> capInstance = LazyOptional.of(InternalTimers::new);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == CAPABILITY) {
                return this.capInstance.cast();
            }
            return LazyOptional.empty();
        }
    }
}

