/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.imc.CustomEMCRegistration;
import moze_intel.projecte.api.imc.IRecipeMapper;
import moze_intel.projecte.api.imc.NSSCreatorInfo;
import moze_intel.projecte.api.imc.WorldTransmutationEntry;
import moze_intel.projecte.api.nss.NSSCreator;
import moze_intel.projecte.emc.json.NSSSerializer;
import moze_intel.projecte.emc.mappers.APICustomEMCMapper;
import moze_intel.projecte.emc.mappers.CraftingMapper;
import moze_intel.projecte.gameObjs.items.rings.TimeWatch;
import moze_intel.projecte.utils.EntityRandomizerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.InterModComms;

public class IMCHandler {
    public static void handleMessages() {
        HashSet interd = new HashSet();
        InterModComms.getMessages((String)"projecte", "blacklist_interdiction"::equals).filter(msg -> msg.getMessageSupplier().get() instanceof EntityType).forEach(msg -> {
            EntityType entityType = (EntityType)msg.getMessageSupplier().get();
            interd.add(entityType);
            PECore.debugLog("Mod: '{}' registered Interdiction Torch Blacklist for EntityType: '{}'", msg.getSenderModId(), entityType.getRegistryName());
        });
        WorldHelper.setInterdictionBlacklist(interd);
        HashSet swrg = new HashSet();
        InterModComms.getMessages((String)"projecte", "blacklist_swrg"::equals).filter(msg -> msg.getMessageSupplier().get() instanceof EntityType).forEach(msg -> {
            EntityType entityType = (EntityType)msg.getMessageSupplier().get();
            swrg.add(entityType);
            PECore.debugLog("Mod: '{}' registered Swiftwolf Rending Gale Blacklist for EntityType: '{}'", msg.getSenderModId(), entityType.getRegistryName());
        });
        WorldHelper.setSwrgBlacklist(swrg);
        HashSet timeWatch = new HashSet();
        InterModComms.getMessages((String)"projecte", "blacklist_timewatch"::equals).filter(msg -> msg.getMessageSupplier().get() instanceof TileEntityType).forEach(msg -> {
            TileEntityType tileEntityType = (TileEntityType)msg.getMessageSupplier().get();
            timeWatch.add(tileEntityType);
            PECore.debugLog("Mod: '{}' registered Time Watch Blacklist for TileEntityType: '{}'", msg.getSenderModId(), tileEntityType.getRegistryName());
        });
        TimeWatch.setInternalBlacklist(timeWatch);
        EntityRandomizerHelper.setDefaultPeacefulRandomizers(IMCHandler.getRandomizerEntities(true));
        EntityRandomizerHelper.setDefaultHostileRandomizers(IMCHandler.getRandomizerEntities(false));
        ArrayList<WorldTransmutationEntry> entries = new ArrayList<WorldTransmutationEntry>();
        InterModComms.getMessages((String)"projecte", "register_world_transmutation"::equals).filter(msg -> msg.getMessageSupplier().get() instanceof WorldTransmutationEntry).forEach(msg -> {
            WorldTransmutationEntry transmutationEntry = (WorldTransmutationEntry)msg.getMessageSupplier().get();
            entries.add(transmutationEntry);
            if (transmutationEntry.getAltResult() == null) {
                PECore.debugLog("Mod: '{}' registered World Transmutation from: '{}', to: '{}'", msg.getSenderModId(), transmutationEntry.getOrigin(), transmutationEntry.getResult());
            } else {
                PECore.debugLog("Mod: '{}' registered World Transmutation from: '{}', to: '{}', with sneak output of: '{}'", msg.getSenderModId(), transmutationEntry.getOrigin(), transmutationEntry.getResult(), transmutationEntry.getAltResult());
            }
        });
        WorldTransmutations.setWorldTransmutation(entries);
        InterModComms.getMessages((String)"projecte", "register_custom_emc"::equals).filter(msg -> msg.getMessageSupplier().get() instanceof CustomEMCRegistration).forEach(msg -> APICustomEMCMapper.INSTANCE.registerCustomEMC(msg.getSenderModId(), (CustomEMCRegistration)msg.getMessageSupplier().get()));
        HashMap<String, NSSCreator> creators = new HashMap<String, NSSCreator>();
        InterModComms.getMessages((String)"projecte", "register_nss_serializer"::equals).filter(msg -> msg.getMessageSupplier().get() instanceof NSSCreatorInfo).forEach(msg -> {
            NSSCreatorInfo creatorInfo = (NSSCreatorInfo)msg.getMessageSupplier().get();
            String key = creatorInfo.getKey();
            if (creators.containsKey(key)) {
                PECore.LOGGER.warn("Mod: '{}' tried to register NSS creator with key: '{}', but another mod already registered that key.", (Object)msg.getSenderModId(), (Object)key);
            } else {
                creators.put(key, creatorInfo.getCreator());
                PECore.debugLog("Mod: '{}' registered NSS creator with key: '{}'", msg.getSenderModId(), key);
            }
        });
        NSSSerializer.INSTANCE.setCreators(creators);
        ArrayList<IRecipeMapper> irecipeMappers = new ArrayList<IRecipeMapper>();
        InterModComms.getMessages((String)"projecte", "register_mappable_irecipe"::equals).filter(msg -> msg.getMessageSupplier().get() instanceof IRecipeMapper).forEach(msg -> {
            IRecipeMapper iRecipeMapper = (IRecipeMapper)msg.getMessageSupplier().get();
            irecipeMappers.add(iRecipeMapper);
            PECore.debugLog("Mod: '{}' registered an IRecipeMapper with the name: '{}'", msg.getSenderModId(), iRecipeMapper.getName());
        });
        CraftingMapper.setRecipeMappers(irecipeMappers);
    }

    private static List<EntityType<? extends MobEntity>> getRandomizerEntities(boolean peaceful) {
        ArrayList<EntityType<? extends MobEntity>> entities = new ArrayList<EntityType<? extends MobEntity>>();
        String imcMethod = peaceful ? "entity_randomization_peaceful" : "entity_randomization_hostile";
        String type = peaceful ? "peaceful" : "hostile";
        InterModComms.getMessages((String)"projecte", imcMethod::equals).filter(msg -> msg.getMessageSupplier().get() instanceof EntityType).forEach(msg -> {
            EntityType genericEntityType = (EntityType)msg.getMessageSupplier().get();
            EntityType<? extends MobEntity> entityType = EntityRandomizerHelper.getEntityIfMob(genericEntityType);
            if (entityType == null) {
                PECore.LOGGER.warn("Mod: '{}' tried to register a {} entity randomizer for the entity: '{}', but that entity is not a MobEntity.", (Object)msg.getSenderModId(), (Object)type, (Object)genericEntityType.getRegistryName());
            } else {
                entities.add(entityType);
                PECore.debugLog("Mod: '{}' registered a {} entity randomizer for the entity: '{}'", msg.getSenderModId(), type, entityType.getRegistryName());
            }
        });
        return entities;
    }
}

