/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.crafttweaker.actions;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import moze_intel.projecte.utils.EntityRandomizerHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;

public abstract class EntityRandomizerAction
implements IUndoableAction {
    protected final EntityType<? extends MobEntity> entityType;
    protected final String typeName;
    protected final boolean peaceful;

    private EntityRandomizerAction(EntityType<? extends MobEntity> entityType, String typeName, boolean peaceful) {
        this.entityType = entityType;
        this.typeName = typeName;
        this.peaceful = peaceful;
    }

    protected void apply(boolean add) {
        if (this.peaceful) {
            if (add) {
                EntityRandomizerHelper.addPeacefulMob(this.entityType);
            } else {
                EntityRandomizerHelper.removePeacefulMob(this.entityType);
            }
        } else if (add) {
            EntityRandomizerHelper.addHostileMob(this.entityType);
        } else {
            EntityRandomizerHelper.removeHostileMob(this.entityType);
        }
    }

    public static class Clear
    implements IUndoableAction {
        private boolean peaceful;

        public Clear(boolean peaceful) {
            this.peaceful = peaceful;
        }

        public void apply() {
            if (this.peaceful) {
                EntityRandomizerHelper.clearPeacefulMobs();
            } else {
                EntityRandomizerHelper.clearHostileMobs();
            }
        }

        public String describe() {
            return "Cleared the " + (this.peaceful ? "peaceful" : "hostile") + " Philosopher Stone Entity Randomizer.";
        }

        public void undo() {
            if (this.peaceful) {
                EntityRandomizerHelper.resetPeacefulMobs();
            } else {
                EntityRandomizerHelper.resetHostileMobs();
            }
        }

        public String describeUndo() {
            return "Restored the " + (this.peaceful ? "peaceful" : "hostile") + " Philosopher Stone Entity Randomizer to default.";
        }
    }

    public static class Remove
    extends EntityRandomizerAction {
        public Remove(EntityType<? extends MobEntity> living, String typeName, boolean peaceful) {
            super(living, typeName, peaceful);
        }

        public void apply() {
            this.apply(false);
        }

        public String describe() {
            return "Removed " + this.typeName + " from the " + (this.peaceful ? "peaceful" : "hostile") + " Philosopher Stone Entity Randomizer.";
        }

        public void undo() {
            this.apply(true);
        }

        public String describeUndo() {
            return "Undid removal of " + this.typeName + " from the " + (this.peaceful ? "peaceful" : "hostile") + " Philosopher Stone Entity Randomizer.";
        }
    }

    public static class Add
    extends EntityRandomizerAction {
        public Add(EntityType<? extends MobEntity> living, String typeName, boolean peaceful) {
            super(living, typeName, peaceful);
        }

        public void apply() {
            this.apply(true);
        }

        public String describe() {
            return "Added " + this.typeName + " to the " + (this.peaceful ? "peaceful" : "hostile") + " Philosopher Stone Entity Randomizer.";
        }

        public void undo() {
            this.apply(false);
        }

        public String describeUndo() {
            return "Undid Addition of " + this.typeName + " to the " + (this.peaceful ? "peaceful" : "hostile") + " Philosopher Stone Entity Randomizer.";
        }
    }
}

