/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import moze_intel.projecte.PECore;

public class ThreadCheckUUID
extends Thread {
    private static boolean hasRunServer = false;
    private static boolean hasRunClient = false;
    private static final String uuidURL = "https://raw.githubusercontent.com/sinkillerj/ProjectE/mc1.14.x/haUUID.txt";
    private final boolean isServerSide;

    public ThreadCheckUUID(boolean isServer) {
        this.isServerSide = isServer;
        this.setName("ProjectE UUID Checker " + (isServer ? "Server" : "Client"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(uuidURL).openStream()));){
            String line = reader.readLine();
            if (line == null) {
                PECore.LOGGER.fatal("UUID check failed!");
                throw new IOException("No data from github UUID list!");
            }
            ArrayList<String> uuids = new ArrayList<String>();
            while ((line = reader.readLine()) != null && !line.startsWith("###UUID")) {
                if (line.isEmpty()) continue;
                uuids.add(line);
            }
            PECore.uuids.addAll(uuids);
        }
        catch (IOException e) {
            PECore.LOGGER.fatal("Caught exception in UUID Checker thread!");
            e.printStackTrace();
        }
        finally {
            if (this.isServerSide) {
                hasRunServer = true;
            } else {
                hasRunClient = true;
            }
        }
    }

    public static boolean hasRunServer() {
        return hasRunServer;
    }

    public static boolean hasRunClient() {
        return hasRunClient;
    }
}

