/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands.parser;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ItemParser;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class NSSItemParser {
    private static final DynamicCommandExceptionType UNKNOWN_TAG = new DynamicCommandExceptionType(tagId -> new TranslationTextComponent("arguments.item.tag.unknown", new Object[]{tagId}));
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> DEFAULT_SUGGESTIONS_BUILDER = SuggestionsBuilder::buildFuture;
    private final StringReader reader;
    @Nullable
    private Item item;
    @Nullable
    private CompoundNBT nbt;
    private ResourceLocation tagId = new ResourceLocation("");
    private int readerCursor;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestionsBuilder = DEFAULT_SUGGESTIONS_BUILDER;

    public NSSItemParser(StringReader readerIn) {
        this.reader = readerIn;
    }

    public NSSItemResult getResult() throws CommandSyntaxException {
        if (this.item != null) {
            return new NSSItemResult(this);
        }
        Tag tag = ItemTags.func_199903_a().func_199910_a(this.tagId);
        if (tag == null) {
            throw UNKNOWN_TAG.create((Object)this.tagId.toString());
        }
        return new NSSItemResult(this);
    }

    public NSSItemParser parse() throws CommandSyntaxException {
        this.suggestionsBuilder = this::suggestTagOrItem;
        if (this.reader.canRead() && this.reader.peek() == '#') {
            this.suggestionsBuilder = this::suggestTag;
            this.reader.expect('#');
            this.readerCursor = this.reader.getCursor();
            this.tagId = ResourceLocation.func_195826_a((StringReader)this.reader);
        } else {
            int i = this.reader.getCursor();
            ResourceLocation itemId = ResourceLocation.func_195826_a((StringReader)this.reader);
            this.item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (this.item == null) {
                this.reader.setCursor(i);
                throw ItemParser.field_197333_a.createWithContext((ImmutableStringReader)this.reader, (Object)itemId);
            }
            this.suggestionsBuilder = this::suggestItem;
            if (this.reader.canRead() && this.reader.peek() == '{') {
                this.suggestionsBuilder = DEFAULT_SUGGESTIONS_BUILDER;
                this.nbt = new JsonToNBT(this.reader).func_193593_f();
            }
        }
        return this;
    }

    private CompletableFuture<Suggestions> suggestItem(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf('{'));
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestTag(SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197014_a((Iterable)ItemTags.func_199903_a().func_199908_a(), (SuggestionsBuilder)builder.createOffset(this.readerCursor));
    }

    private CompletableFuture<Suggestions> suggestTagOrItem(SuggestionsBuilder builder) {
        ISuggestionProvider.func_197006_a((Iterable)ItemTags.func_199903_a().func_199908_a(), (SuggestionsBuilder)builder, (String)String.valueOf('#'));
        return ISuggestionProvider.func_197014_a((Iterable)ForgeRegistries.ITEMS.getKeys(), (SuggestionsBuilder)builder);
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder builder) {
        return this.suggestionsBuilder.apply(builder.createOffset(this.reader.getCursor()));
    }

    public static class NSSItemResult {
        @Nullable
        private Item item;
        @Nullable
        private CompoundNBT nbt;
        private ResourceLocation tagId = new ResourceLocation("");

        public NSSItemResult(NSSItemParser parser) {
            this.item = parser.item;
            this.nbt = parser.nbt;
            this.tagId = parser.tagId;
        }

        public NSSItemResult(@Nonnull ItemStack stack) {
            this.item = stack.func_77973_b();
            this.nbt = stack.func_77978_p();
        }

        public String getStringRepresentation() {
            if (this.item == null) {
                return "#" + this.tagId;
            }
            if (this.nbt == null) {
                return this.item.getRegistryName().toString();
            }
            return this.item.getRegistryName().toString() + this.nbt;
        }
    }
}

