/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets;

import java.util.Optional;
import java.util.function.Supplier;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.api.capabilities.item.IModeChanger;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.gameObjs.items.armor.GemChest;
import moze_intel.projecte.gameObjs.items.armor.GemFeet;
import moze_intel.projecte.gameObjs.items.armor.GemHelmet;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.utils.LazyOptionalHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class KeyPressPKT {
    private final PEKeybind key;

    public KeyPressPKT(PEKeybind key) {
        this.key = key;
    }

    public static void encode(KeyPressPKT pkt, PacketBuffer buf) {
        buf.func_150787_b(pkt.key.ordinal());
    }

    public static KeyPressPKT decode(PacketBuffer buf) {
        return new KeyPressPKT(PEKeybind.values()[buf.func_150792_a()]);
    }

    public static class Handler {
        public static void handle(KeyPressPKT message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Optional cap = LazyOptionalHelper.toOptional(player.getCapability(InternalAbilities.CAPABILITY));
                if (!cap.isPresent()) {
                    return;
                }
                InternalAbilities internalAbilities = (InternalAbilities)cap.get();
                if (message.key == PEKeybind.ARMOR_TOGGLE) {
                    if (player.func_70093_af()) {
                        ItemStack helm = player.func_184582_a(EquipmentSlotType.HEAD);
                        if (!helm.func_190926_b() && helm.func_77973_b() instanceof GemHelmet) {
                            GemHelmet.toggleNightVision(helm, (PlayerEntity)player);
                        }
                    } else {
                        ItemStack boots = player.func_184582_a(EquipmentSlotType.FEET);
                        if (!boots.func_190926_b() && boots.func_77973_b() instanceof GemFeet) {
                            ((GemFeet)boots.func_77973_b()).toggleStepAssist(boots, (PlayerEntity)player);
                        }
                    }
                    return;
                }
                block6: for (Hand hand : Hand.values()) {
                    ItemStack stack = player.func_184586_b(hand);
                    switch (message.key) {
                        case CHARGE: {
                            Optional chargeCapability;
                            if (!stack.func_190926_b() && (chargeCapability = LazyOptionalHelper.toOptional(stack.getCapability(ProjectEAPI.CHARGE_ITEM_CAPABILITY))).isPresent() && ((IItemCharge)chargeCapability.get()).changeCharge((PlayerEntity)player, stack, hand)) {
                                return;
                            }
                            if (hand != Hand.MAIN_HAND || !((Boolean)ProjectEConfig.server.misc.unsafeKeyBinds.get()).booleanValue() && !stack.func_190926_b() || !GemArmorBase.hasAnyPiece((PlayerEntity)player)) continue block6;
                            internalAbilities.setGemState(!internalAbilities.getGemState());
                            player.func_145747_a((ITextComponent)new TranslationTextComponent(internalAbilities.getGemState() ? "pe.gem.activate" : "pe.gem.deactivate", new Object[0]));
                            return;
                        }
                        case EXTRA_FUNCTION: {
                            ItemStack chestplate;
                            Optional extraFunctionCapability;
                            if (!stack.func_190926_b() && (extraFunctionCapability = LazyOptionalHelper.toOptional(stack.getCapability(ProjectEAPI.EXTRA_FUNCTION_ITEM_CAPABILITY))).isPresent() && ((IExtraFunction)extraFunctionCapability.get()).doExtraFunction(stack, (PlayerEntity)player, hand)) {
                                return;
                            }
                            if (hand != Hand.MAIN_HAND || !((Boolean)ProjectEConfig.server.misc.unsafeKeyBinds.get()).booleanValue() && !stack.func_190926_b() || !internalAbilities.getGemState() || (chestplate = player.func_184582_a(EquipmentSlotType.CHEST)).func_190926_b() || !(chestplate.func_77973_b() instanceof GemChest) || internalAbilities.getGemCooldown() != 0) continue block6;
                            ((GemChest)chestplate.func_77973_b()).doExplode((PlayerEntity)player);
                            internalAbilities.resetGemCooldown();
                            return;
                        }
                        case FIRE_PROJECTILE: {
                            ItemStack helmet;
                            Optional projectileShooterCapability;
                            if (!stack.func_190926_b() && internalAbilities.getProjectileCooldown() == 0 && (projectileShooterCapability = LazyOptionalHelper.toOptional(stack.getCapability(ProjectEAPI.PROJECTILE_SHOOTER_ITEM_CAPABILITY))).isPresent() && ((IProjectileShooter)projectileShooterCapability.get()).shootProjectile((PlayerEntity)player, stack, hand)) {
                                PlayerHelper.swingItem((PlayerEntity)player, hand);
                                internalAbilities.resetProjectileCooldown();
                                return;
                            }
                            if (hand != Hand.MAIN_HAND || !((Boolean)ProjectEConfig.server.misc.unsafeKeyBinds.get()).booleanValue() && !stack.func_190926_b() || !internalAbilities.getGemState() || (helmet = player.func_184582_a(EquipmentSlotType.HEAD)).func_190926_b() || !(helmet.func_77973_b() instanceof GemHelmet)) continue block6;
                            ((GemHelmet)helmet.func_77973_b()).doZap((PlayerEntity)player);
                            return;
                        }
                        case MODE: {
                            Optional modeChangerCapability;
                            if (stack.func_190926_b() || !(modeChangerCapability = LazyOptionalHelper.toOptional(stack.getCapability(ProjectEAPI.MODE_CHANGER_ITEM_CAPABILITY))).isPresent() || !((IModeChanger)modeChangerCapability.get()).changeMode((PlayerEntity)player, stack, hand)) continue block6;
                            return;
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

