/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.gameObjs.container.CondenserContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class UpdateCondenserLockPKT {
    @Nullable
    private final ItemInfo lockInfo;
    private final short windowId;

    public UpdateCondenserLockPKT(short windowId, @Nullable ItemInfo lockInfo) {
        this.windowId = windowId;
        this.lockInfo = lockInfo;
    }

    public static void encode(UpdateCondenserLockPKT msg, PacketBuffer buf) {
        buf.writeShort((int)msg.windowId);
        if (msg.lockInfo == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeRegistryId((IForgeRegistryEntry)msg.lockInfo.getItem());
            buf.func_150786_a(msg.lockInfo.getNBT());
        }
    }

    public static UpdateCondenserLockPKT decode(PacketBuffer buf) {
        short windowId = buf.readShort();
        boolean hasInfo = buf.readBoolean();
        ItemInfo lockInfo = null;
        if (hasInfo) {
            lockInfo = ItemInfo.fromItem((Item)buf.readRegistryId(), buf.func_150793_b());
        }
        return new UpdateCondenserLockPKT(windowId, lockInfo);
    }

    public static class Handler {
        public static void handle(UpdateCondenserLockPKT msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> Handler.handleClient(msg));
            ctx.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void handleClient(UpdateCondenserLockPKT msg) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player.field_71070_bA instanceof CondenserContainer && player.field_71070_bA.field_75152_c == msg.windowId) {
                ((CondenserContainer)player.field_71070_bA).updateLockInfo(msg.lockInfo);
            }
        }
    }
}

