/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets;

import java.util.function.Supplier;
import moze_intel.projecte.gameObjs.container.PEContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateWindowIntPKT {
    private final short windowId;
    private final short propId;
    private final int propVal;

    public UpdateWindowIntPKT(short windowId, short propId, int propVal) {
        this.windowId = windowId;
        this.propId = propId;
        this.propVal = propVal;
    }

    public static void encode(UpdateWindowIntPKT msg, PacketBuffer buf) {
        buf.writeShort((int)msg.windowId);
        buf.writeShort((int)msg.propId);
        buf.func_150787_b(msg.propVal);
    }

    public static UpdateWindowIntPKT decode(PacketBuffer buf) {
        return new UpdateWindowIntPKT(buf.readShort(), buf.readShort(), buf.func_150792_a());
    }

    public static class Handler {
        public static void handle(UpdateWindowIntPKT msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> Handler.handleClient(msg));
            ctx.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void handleClient(UpdateWindowIntPKT msg) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player.field_71070_bA instanceof PEContainer && player.field_71070_bA.field_75152_c == msg.windowId) {
                ((PEContainer)player.field_71070_bA).updateProgressBarInt(msg.propId, msg.propVal);
            }
        }
    }
}

