/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.rendering;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.tiles.ChestTileEmc;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.model.ChestModel;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class ChestRenderer
extends TileEntityRenderer<ChestTileEmc> {
    private final ChestModel model = new ChestModel();
    private final Predicate<Block> blockChecker;
    private final ResourceLocation texture;

    public ChestRenderer(ResourceLocation texture, Predicate<Block> blockChecker) {
        this.texture = texture;
        this.blockChecker = blockChecker;
    }

    public void render(@Nonnull ChestTileEmc chestTile, double x, double y, double z, float partialTicks, int destroyStage) {
        Direction direction = null;
        if (chestTile.func_145831_w() != null && !chestTile.func_145837_r()) {
            BlockState state = chestTile.func_145831_w().func_180495_p(chestTile.func_174877_v());
            direction = this.blockChecker.test(state.func_177230_c()) ? (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J) : null;
        }
        this.func_147499_a(this.texture);
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translated((double)x, (double)(y + 1.0), (double)(z + 1.0));
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
        int angle = 0;
        if (direction != null) {
            switch (direction) {
                case NORTH: {
                    angle = 180;
                    break;
                }
                case SOUTH: {
                    angle = 0;
                    break;
                }
                case WEST: {
                    angle = 90;
                    break;
                }
                case EAST: {
                    angle = -90;
                }
            }
        }
        GlStateManager.rotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float adjustedLidAngle = chestTile.func_195480_a(partialTicks);
        adjustedLidAngle = 1.0f - adjustedLidAngle;
        adjustedLidAngle = 1.0f - adjustedLidAngle * adjustedLidAngle * adjustedLidAngle;
        this.model.func_205058_b().field_78795_f = -(adjustedLidAngle * (float)Math.PI / 2.0f);
        this.model.func_78231_a();
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

