/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.items.KleinStar;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.LazyOptionalHelper;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class EMCHelper {
    public static long consumePlayerFuel(PlayerEntity player, long minFuel) {
        ItemStack offhand;
        long actualExtracted;
        if (player.field_71075_bZ.field_75098_d) {
            return minFuel;
        }
        IItemHandler curios = PlayerHelper.getCurios(player);
        if (curios != null) {
            for (int i = 0; i < curios.getSlots(); ++i) {
                actualExtracted = EMCHelper.tryExtract(curios.getStackInSlot(i), minFuel);
                if (actualExtracted <= 0L) continue;
                player.field_71070_bA.func_75142_b();
                return actualExtracted;
            }
        }
        if (!(offhand = player.func_184592_cb()).func_190926_b() && (actualExtracted = EMCHelper.tryExtract(offhand, minFuel)) > 0L) {
            player.field_71070_bA.func_75142_b();
            return actualExtracted;
        }
        Optional itemHandlerCap = LazyOptionalHelper.toOptional(player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY));
        if (itemHandlerCap.isPresent()) {
            IItemHandler inv = (IItemHandler)itemHandlerCap.get();
            LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>();
            boolean metRequirement = false;
            long emcConsumed = 0L;
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                long actualExtracted2 = EMCHelper.tryExtract(stack, minFuel);
                if (actualExtracted2 > 0L) {
                    player.field_71070_bA.func_75142_b();
                    return actualExtracted2;
                }
                if (metRequirement || !FuelMapper.isStackFuel(stack)) continue;
                long emc = EMCHelper.getEmcValue(stack);
                int toRemove = (int)Math.ceil((double)(minFuel - emcConsumed) / (double)emc);
                if (stack.func_190916_E() >= toRemove) {
                    map.put(i, toRemove);
                    emcConsumed += emc * (long)toRemove;
                    metRequirement = true;
                    continue;
                }
                map.put(i, stack.func_190916_E());
                if ((emcConsumed += emc * (long)stack.func_190916_E()) < minFuel) continue;
                metRequirement = true;
            }
            if (metRequirement) {
                for (Map.Entry entry : map.entrySet()) {
                    inv.extractItem(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue(), false);
                }
                player.field_71070_bA.func_75142_b();
                return emcConsumed;
            }
        }
        return -1L;
    }

    private static long tryExtract(@Nonnull ItemStack stack, long minFuel) {
        IItemEmcHolder emcHolder;
        long simulatedExtraction;
        if (stack.func_190926_b()) {
            return 0L;
        }
        Optional holderCapability = LazyOptionalHelper.toOptional(stack.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY));
        if (holderCapability.isPresent() && (simulatedExtraction = (emcHolder = (IItemEmcHolder)holderCapability.get()).extractEmc(stack, minFuel, IEmcStorage.EmcAction.SIMULATE)) == minFuel) {
            return emcHolder.extractEmc(stack, simulatedExtraction, IEmcStorage.EmcAction.EXECUTE);
        }
        return 0L;
    }

    public static boolean doesItemHaveEmc(ItemInfo info) {
        return EMCHelper.getEmcValue(info) > 0L;
    }

    public static boolean doesItemHaveEmc(ItemStack stack) {
        return EMCHelper.getEmcValue(stack) > 0L;
    }

    public static boolean doesItemHaveEmc(IItemProvider item) {
        return EMCHelper.getEmcValue(item) > 0L;
    }

    public static long getEmcValue(IItemProvider item) {
        return item == null ? 0L : EMCHelper.getEmcValue(ItemInfo.fromItem(item.func_199767_j()));
    }

    public static long getEmcValue(ItemStack stack) {
        return stack.func_190926_b() ? 0L : EMCHelper.getEmcValue(ItemInfo.fromStack(stack));
    }

    public static long getEmcValue(ItemInfo info) {
        return NBTManager.getEmcValue(info);
    }

    public static long getEmcSellValue(ItemStack stack) {
        return stack.func_190926_b() ? 0L : EMCHelper.getEmcSellValue(ItemInfo.fromStack(stack));
    }

    public static long getEmcSellValue(ItemInfo info) {
        return EMCHelper.getEmcSellValue(EMCHelper.getEmcValue(info));
    }

    public static long getEmcSellValue(long originalValue) {
        if (originalValue <= 0L) {
            return 0L;
        }
        long emc = (long)Math.floor((double)originalValue * (Double)ProjectEConfig.server.difficulty.covalenceLoss.get());
        if (emc < 1L) {
            emc = (Boolean)ProjectEConfig.server.difficulty.covalenceLossRounding.get() != false ? 1L : 0L;
        }
        return emc;
    }

    public static ITextComponent getEmcTextComponent(long emc, int stackSize) {
        ITextComponent prefix = new TranslationTextComponent(stackSize > 1 ? "pe.emc.stackemc_tooltip_prefix" : "pe.emc.emc_tooltip_prefix", new Object[0]).func_211708_a(TextFormatting.YELLOW).func_150258_a(" ");
        ITextComponent valueText = new StringTextComponent(Constants.EMC_FORMATTER.format(stackSize == 1 ? Long.valueOf(emc) : BigInteger.valueOf(emc).multiply(BigInteger.valueOf(stackSize)))).func_211708_a(TextFormatting.WHITE);
        ITextComponent sell = new StringTextComponent(EMCHelper.getEmcSellString(EMCHelper.getEmcSellValue(emc), stackSize)).func_211708_a(TextFormatting.BLUE);
        return prefix.func_150257_a(valueText).func_150257_a(sell);
    }

    public static String getEmcSellString(long emcSellValue, int stackSize) {
        if ((Double)ProjectEConfig.server.difficulty.covalenceLoss.get() == 1.0) {
            return " ";
        }
        if (stackSize == 1) {
            return " (" + Constants.EMC_FORMATTER.format(emcSellValue) + ")";
        }
        return " (" + Constants.EMC_FORMATTER.format(BigInteger.valueOf(emcSellValue).multiply(BigInteger.valueOf(stackSize))) + ")";
    }

    public static long getKleinStarMaxEmc(ItemStack stack) {
        if (stack.func_77973_b() instanceof KleinStar) {
            return Constants.MAX_KLEIN_EMC[((KleinStar)stack.func_77973_b()).tier.ordinal()];
        }
        return 0L;
    }

    public static long getEMCPerDurability(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0L;
        }
        if (stack.func_77984_f()) {
            ItemStack stackCopy = stack.func_77946_l();
            stackCopy.func_196085_b(0);
            long emc = (long)Math.ceil((double)EMCHelper.getEmcValue(stackCopy) / (double)stack.func_77958_k());
            return emc > 1L ? emc : 1L;
        }
        return 1L;
    }

    public static long removeFractionalEMC(ItemStack stack, double amount) {
        CompoundNBT nbt = stack.func_196082_o();
        double unprocessedEMC = nbt.func_74769_h("UnprocessedEMC");
        long toRemove = (long)(unprocessedEMC += amount);
        nbt.func_74780_a("UnprocessedEMC", unprocessedEMC -= (double)toRemove);
        return toRemove;
    }
}

