/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import moze_intel.projecte.utils.CollectionHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.InterModComms;

public class EntityRandomizerHelper {
    private static List<EntityType<? extends MobEntity>> PEACEFUL_DEFAULT = Collections.emptyList();
    private static List<EntityType<? extends MobEntity>> HOSTILE_DEFAULT = Collections.emptyList();
    private static List<EntityType<? extends MobEntity>> peacefulMobs = Collections.emptyList();
    private static List<EntityType<? extends MobEntity>> hostileMobs = Collections.emptyList();

    public static void init() {
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200737_ac);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200784_X);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200796_j);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200780_T);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200795_i);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200791_e);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200756_av);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200749_ao);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200781_U);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200724_aC);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200762_B);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200736_ab);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200798_l);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200779_S);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200786_Z);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200769_I);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_200783_W);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_205137_n);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_203780_j);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_203778_ae);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_203779_Z);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_204262_at);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_203099_aq);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_220360_g);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_220356_B);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_220353_aa);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_220354_ax);
        EntityRandomizerHelper.registerDefault(true, (EntityType<? extends MobEntity>)EntityType.field_220351_aK);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200725_aD);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200741_ag);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200797_k);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200748_an);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200803_q);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200740_af);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200785_Y);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200811_y);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200792_f);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200743_ai);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200759_ay);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200736_ab);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200804_r);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200750_ap);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200722_aA);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200742_ah);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200726_aE);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200727_aF);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200763_C);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200761_A);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200806_t);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200755_au);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200758_ax);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_200738_ad);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_204724_o);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_203097_aH);
        EntityRandomizerHelper.registerDefault(false, (EntityType<? extends MobEntity>)EntityType.field_220350_aJ);
    }

    private static void registerDefault(boolean peaceful, EntityType<? extends MobEntity> entityType) {
        InterModComms.sendTo((String)"projecte", (String)(peaceful ? "entity_randomization_peaceful" : "entity_randomization_hostile"), () -> entityType);
    }

    public static void setDefaultPeacefulRandomizers(List<EntityType<? extends MobEntity>> peacefulDefaults) {
        PEACEFUL_DEFAULT = ImmutableList.copyOf(peacefulDefaults);
        EntityRandomizerHelper.resetPeacefulMobs();
    }

    public static void setDefaultHostileRandomizers(List<EntityType<? extends MobEntity>> hostileDefaults) {
        HOSTILE_DEFAULT = ImmutableList.copyOf(hostileDefaults);
        EntityRandomizerHelper.resetHostileMobs();
    }

    @Nullable
    public static EntityType<? extends MobEntity> getEntityIfMob(EntityType<?> entityType) {
        try {
            return entityType;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static boolean addPeacefulMob(EntityType<? extends MobEntity> type) {
        if (!peacefulMobs.contains(type)) {
            peacefulMobs.add(type);
            return true;
        }
        return false;
    }

    public static boolean removePeacefulMob(EntityType<? extends MobEntity> type) {
        return peacefulMobs.remove(type);
    }

    public static void clearPeacefulMobs() {
        peacefulMobs.clear();
    }

    public static void resetPeacefulMobs() {
        peacefulMobs = new ArrayList<EntityType<? extends MobEntity>>(PEACEFUL_DEFAULT);
    }

    public static boolean addHostileMob(EntityType<? extends MobEntity> type) {
        if (!hostileMobs.contains(type)) {
            hostileMobs.add(type);
            return true;
        }
        return false;
    }

    public static boolean removeHostileMob(EntityType<? extends MobEntity> type) {
        return hostileMobs.remove(type);
    }

    public static void clearHostileMobs() {
        hostileMobs.clear();
    }

    public static void resetHostileMobs() {
        hostileMobs = new ArrayList<EntityType<? extends MobEntity>>(HOSTILE_DEFAULT);
    }

    public static MobEntity getRandomEntity(World world, MobEntity toRandomize) {
        EntityType<? extends MobEntity> entType = EntityRandomizerHelper.getEntityIfMob(toRandomize.func_200600_R());
        if (entType != null) {
            if (peacefulMobs.contains(entType)) {
                return (MobEntity)CollectionHelper.getRandomListEntry(peacefulMobs, entType).func_200721_a(world);
            }
            if (hostileMobs.contains(entType)) {
                MobEntity ent = (MobEntity)CollectionHelper.getRandomListEntry(hostileMobs, entType).func_200721_a(world);
                if (ent instanceof RabbitEntity) {
                    ((RabbitEntity)ent).func_175529_r(99);
                }
                return ent;
            }
        }
        if (world.field_73012_v.nextInt(2) == 0) {
            return (MobEntity)EntityType.field_200743_ai.func_200721_a(world);
        }
        return (MobEntity)EntityType.field_200737_ac.func_200721_a(world);
    }
}

