/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class NovaExplosion
extends Explosion {
    private final World world;
    private final Explosion.Mode mode;
    private final double x;
    private final double y;
    private final double z;
    private final float size;

    public NovaExplosion(World world, @Nullable Entity entity, double x, double y, double z, float radius, boolean causesFire, Explosion.Mode mode) {
        super(world, entity, x, y, z, radius, causesFire, mode);
        this.world = world;
        this.mode = mode;
        this.size = radius;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void func_77279_a(boolean spawnParticles) {
        boolean differentMode;
        this.world.func_184148_a(null, this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        boolean bl = differentMode = this.mode != Explosion.Mode.NONE;
        if (this.size >= 2.0f && differentMode) {
            this.world.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        } else {
            this.world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        }
        NonNullList allDrops = NonNullList.func_191196_a();
        if (differentMode) {
            for (BlockPos pos : this.func_180343_e()) {
                BlockState state = this.world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (spawnParticles) {
                    double d0 = (float)pos.func_177958_n() + this.world.field_73012_v.nextFloat();
                    double d1 = (float)pos.func_177956_o() + this.world.field_73012_v.nextFloat();
                    double d2 = (float)pos.func_177952_p() + this.world.field_73012_v.nextFloat();
                    double d3 = d0 - this.x;
                    double d4 = d1 - this.y;
                    double d5 = d2 - this.z;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.size + 0.1);
                    this.world.func_195594_a((IParticleData)ParticleTypes.field_197598_I, (d0 + this.x) / 2.0, (d1 + this.y) / 2.0, (d2 + this.z) / 2.0, d3 *= (d7 *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                    this.world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, d3, d4, d5);
                }
                if (this.world.func_175623_d(pos)) continue;
                pos = pos.func_185334_h();
                if (this.world instanceof ServerWorld && state.canDropFromExplosion((IBlockReader)this.world, pos, (Explosion)this)) {
                    TileEntity tileentity = state.hasTileEntity() ? this.world.func_175625_s(pos) : null;
                    LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.world).func_216023_a(this.world.field_73012_v).func_216015_a(LootParameters.field_216286_f, (Object)pos).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity);
                    if (this.mode == Explosion.Mode.DESTROY) {
                        builder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(this.size));
                    }
                    allDrops.addAll((Collection)state.func_215693_a(builder));
                    state.func_215706_a(this.world, pos, ItemStack.field_190927_a);
                }
                this.world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                block.func_180652_a(this.world, pos, (Explosion)this);
            }
        }
        if (this.func_94613_c() != null) {
            WorldHelper.createLootDrop((List<ItemStack>)allDrops, this.world, new BlockPos((Entity)this.func_94613_c()));
        } else {
            WorldHelper.createLootDrop((List<ItemStack>)allDrops, this.world, this.x, this.y, this.z);
        }
    }
}

