/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.item.IModeChanger;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.config.TomeEnabledCondition;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.EMCReloadListener;
import moze_intel.projecte.emc.json.NSSSerializer;
import moze_intel.projecte.emc.mappers.recipe.CraftingMapper;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.customRecipes.PhilStoneSmeltingHelper;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.impl.IMCHandler;
import moze_intel.projecte.impl.TransmutationOffline;
import moze_intel.projecte.impl.capability.AlchBagImpl;
import moze_intel.projecte.impl.capability.AlchBagItemDefaultImpl;
import moze_intel.projecte.impl.capability.AlchChestItemDefaultImpl;
import moze_intel.projecte.impl.capability.ChargeItemDefaultImpl;
import moze_intel.projecte.impl.capability.EmcHolderItemDefaultImpl;
import moze_intel.projecte.impl.capability.EmcStorageDefaultImpl;
import moze_intel.projecte.impl.capability.ExtraFunctionItemDefaultImpl;
import moze_intel.projecte.impl.capability.KnowledgeImpl;
import moze_intel.projecte.impl.capability.ModeChangerItemDefaultImpl;
import moze_intel.projecte.impl.capability.PedestalItemDefaultImpl;
import moze_intel.projecte.impl.capability.ProjectileShooterItemDefaultImpl;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.ThreadCheckUUID;
import moze_intel.projecte.network.ThreadCheckUpdate;
import moze_intel.projecte.network.commands.ClearKnowledgeCMD;
import moze_intel.projecte.network.commands.RemoveEmcCMD;
import moze_intel.projecte.network.commands.ResetEmcCMD;
import moze_intel.projecte.network.commands.SetEmcCMD;
import moze_intel.projecte.network.commands.ShowBagCMD;
import moze_intel.projecte.network.commands.argument.ColorArgument;
import moze_intel.projecte.network.commands.argument.NSSItemArgument;
import moze_intel.projecte.network.commands.argument.UUIDArgument;
import moze_intel.projecte.rendering.ChestRenderer;
import moze_intel.projecte.rendering.LayerYue;
import moze_intel.projecte.rendering.NovaRenderer;
import moze_intel.projecte.rendering.PedestalRenderer;
import moze_intel.projecte.rendering.entity.ExplosiveLensRenderer;
import moze_intel.projecte.rendering.entity.FireballRenderer;
import moze_intel.projecte.rendering.entity.LavaOrbRenderer;
import moze_intel.projecte.rendering.entity.LightningRenderer;
import moze_intel.projecte.rendering.entity.RandomizerRenderer;
import moze_intel.projecte.rendering.entity.WaterOrbRenderer;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.DummyIStorage;
import moze_intel.projecte.utils.EntityRandomizerHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.TippedArrowRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="projecte")
@Mod.EventBusSubscriber(modid="projecte")
public class PECore {
    public static final String MODID = "projecte";
    public static final String MODNAME = "ProjectE";
    public static final GameProfile FAKEPLAYER_GAMEPROFILE = new GameProfile(UUID.fromString("590e39c7-9fb6-471b-a4c2-c0e539b2423d"), "[ProjectE]");
    public static boolean DEV_ENVIRONMENT;
    public static final Logger LOGGER;
    public static final List<String> uuids;
    public static ModContainer MOD_CONTAINER;

    public static void debugLog(String msg, Object ... args) {
        if (DEV_ENVIRONMENT || ((Boolean)ProjectEConfig.common.debugLogging.get()).booleanValue()) {
            LOGGER.info(msg, args);
        } else {
            LOGGER.debug(msg, args);
        }
    }

    public PECore() {
        MOD_CONTAINER = ModLoadingContext.get().getActiveContainer();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientHandler::clientSetup);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientHandler::loadComplete);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientHandler::onStitch);
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcQueue);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcHandle);
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::serverAboutToStartLowest);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverQuit);
        ProjectEConfig.register();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        DEV_ENVIRONMENT = FMLLoader.getNameFunction((String)"srg").isPresent();
        AlchBagImpl.init();
        KnowledgeImpl.init();
        CapabilityManager.INSTANCE.register(InternalTimers.class, new DummyIStorage(), InternalTimers::new);
        CapabilityManager.INSTANCE.register(InternalAbilities.class, new DummyIStorage(), () -> new InternalAbilities(null));
        CapabilityManager.INSTANCE.register(IAlchBagItem.class, new DummyIStorage(), AlchBagItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IAlchChestItem.class, new DummyIStorage(), AlchChestItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IExtraFunction.class, new DummyIStorage(), ExtraFunctionItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IItemCharge.class, new DummyIStorage(), ChargeItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IItemEmcHolder.class, new DummyIStorage(), EmcHolderItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IModeChanger.class, new DummyIStorage(), ModeChangerItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IPedestalItem.class, new DummyIStorage(), PedestalItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IProjectileShooter.class, new DummyIStorage(), ProjectileShooterItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IEmcStorage.class, new DummyIStorage(), EmcStorageDefaultImpl::new);
        new ThreadCheckUpdate().start();
        EMCMappingHandler.loadMappers();
        CraftingMapper.loadMappers();
        NBTManager.loadProcessors();
        DeferredWorkQueue.runLater(() -> {
            PacketHandler.register();
            CraftingHelper.register(TomeEnabledCondition.SERIALIZER);
            ArgumentTypes.func_218136_a((String)"projecte:uuid", UUIDArgument.class, (IArgumentSerializer)new ArgumentSerializer(UUIDArgument::new));
            ArgumentTypes.func_218136_a((String)"projecte:color", ColorArgument.class, (IArgumentSerializer)new ArgumentSerializer(ColorArgument::new));
            ArgumentTypes.func_218136_a((String)"projecte:nss", NSSItemArgument.class, (IArgumentSerializer)new ArgumentSerializer(NSSItemArgument::new));
        });
    }

    private void imcQueue(InterModEnqueueEvent event) {
        EntityRandomizerHelper.init();
        WorldTransmutations.init();
        NSSSerializer.init();
        IntegrationHelper.sendIMCMessages(event);
    }

    private void imcHandle(InterModProcessEvent event) {
        IMCHandler.handleMessages();
    }

    private void serverAboutToStart(FMLServerAboutToStartEvent event) {
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new PhilStoneSmeltingHelper());
    }

    private void serverAboutToStartLowest(FMLServerAboutToStartEvent event) {
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new EMCReloadListener());
    }

    private void serverStarting(FMLServerStartingEvent event) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)MODID).then(ClearKnowledgeCMD.register())).then(RemoveEmcCMD.register())).then(ResetEmcCMD.register())).then(SetEmcCMD.register())).then(ShowBagCMD.register());
        event.getCommandDispatcher().register(root);
        if (!ThreadCheckUUID.hasRunServer()) {
            new ThreadCheckUUID(true).start();
        }
    }

    private void serverQuit(FMLServerStoppedEvent event) {
        TransmutationOffline.cleanAll();
        EMCMappingHandler.clearEmcMap();
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        uuids = new ArrayList<String>();
    }

    static class ClientHandler {
        ClientHandler() {
        }

        static void clientSetup(FMLClientSetupEvent evt) {
            DeferredWorkQueue.runLater(ClientKeyHelper::registerKeyBindings);
            ClientRegistry.bindTileEntityRenderer(ObjHandler.ALCH_CHEST_TILE, dispatcher -> new ChestRenderer((TileEntityRendererDispatcher)dispatcher, new ResourceLocation(PECore.MODID, "textures/blocks/alchemy_chest.png"), block -> block == ObjHandler.alchChest));
            ClientRegistry.bindTileEntityRenderer(ObjHandler.CONDENSER_TILE, dispatcher -> new ChestRenderer((TileEntityRendererDispatcher)dispatcher, new ResourceLocation(PECore.MODID, "textures/blocks/condenser.png"), block -> block == ObjHandler.condenser));
            ClientRegistry.bindTileEntityRenderer(ObjHandler.CONDENSER_MK2_TILE, dispatcher -> new ChestRenderer((TileEntityRendererDispatcher)dispatcher, new ResourceLocation(PECore.MODID, "textures/blocks/condenser_mk2.png"), block -> block == ObjHandler.condenserMk2));
            ClientRegistry.bindTileEntityRenderer(ObjHandler.DM_PEDESTAL_TILE, PedestalRenderer::new);
            RenderingRegistry.registerEntityRenderingHandler(ObjHandler.WATER_PROJECTILE, WaterOrbRenderer::new);
            RenderingRegistry.registerEntityRenderingHandler(ObjHandler.LAVA_PROJECTILE, LavaOrbRenderer::new);
            RenderingRegistry.registerEntityRenderingHandler(ObjHandler.MOB_RANDOMIZER, RandomizerRenderer::new);
            RenderingRegistry.registerEntityRenderingHandler(ObjHandler.LENS_PROJECTILE, ExplosiveLensRenderer::new);
            RenderingRegistry.registerEntityRenderingHandler(ObjHandler.FIRE_PROJECTILE, FireballRenderer::new);
            RenderingRegistry.registerEntityRenderingHandler(ObjHandler.SWRG_PROJECTILE, LightningRenderer::new);
            RenderingRegistry.registerEntityRenderingHandler(ObjHandler.NOVA_CATALYST_PRIMED, manager -> new NovaRenderer(manager, () -> ((Block)ObjHandler.novaCatalyst).func_176223_P()));
            RenderingRegistry.registerEntityRenderingHandler(ObjHandler.NOVA_CATACLYSM_PRIMED, manager -> new NovaRenderer(manager, () -> ((Block)ObjHandler.novaCataclysm).func_176223_P()));
            RenderingRegistry.registerEntityRenderingHandler(ObjHandler.HOMING_ARROW, TippedArrowRenderer::new);
            RenderTypeLookup.setRenderLayer((Block)ObjHandler.interdictionTorch, (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)ObjHandler.interdictionTorchWall, (RenderType)RenderType.func_228643_e_());
        }

        static void loadComplete(FMLLoadCompleteEvent evt) {
            DeferredWorkQueue.runLater(() -> {
                Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
                PlayerRenderer render = (PlayerRenderer)skinMap.get("default");
                render.func_177094_a((LayerRenderer)new LayerYue(render));
                render = (PlayerRenderer)skinMap.get("slim");
                render.func_177094_a((LayerRenderer)new LayerYue(render));
            });
        }

        static void onStitch(TextureStitchEvent.Pre evt) {
            if (evt.getMap().func_229223_g_().equals((Object)AtlasTexture.field_110575_b) && ModList.get().isLoaded("curios")) {
                evt.addSprite(IntegrationHelper.CURIOS_KLEIN_STAR);
            }
        }
    }
}

