/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileEmcBase
extends TileEntity
implements IEmcStorage {
    private LazyOptional<IEmcStorage> emcStorageCapability = LazyOptional.of(() -> this);
    private long maximumEMC;
    private long currentEMC;

    protected TileEmcBase(TileEntityType<?> type) {
        super(type);
        this.setMaximumEMC(Long.MAX_VALUE);
    }

    public final void setMaximumEMC(long max) {
        this.maximumEMC = max;
        if (this.getStoredEmc() > this.getMaximumEmc()) {
            this.currentEMC = this.getMaximumEmc();
        }
    }

    @Override
    public long getStoredEmc() {
        return this.currentEMC;
    }

    @Override
    public long getMaximumEmc() {
        return this.maximumEMC;
    }

    protected long getEmcInsertLimit() {
        return this.getNeededEmc();
    }

    protected long getEmcExtractLimit() {
        return this.getStoredEmc();
    }

    protected boolean canAcceptEmc() {
        return true;
    }

    protected boolean canProvideEmc() {
        return true;
    }

    @Override
    public long extractEmc(long toExtract, IEmcStorage.EmcAction action) {
        if (toExtract < 0L) {
            return this.insertEmc(-toExtract, action);
        }
        if (this.canProvideEmc()) {
            return this.forceExtractEmc(Math.min(this.getEmcExtractLimit(), toExtract), action);
        }
        return 0L;
    }

    @Override
    public long insertEmc(long toAccept, IEmcStorage.EmcAction action) {
        if (toAccept < 0L) {
            return this.extractEmc(-toAccept, action);
        }
        if (this.canAcceptEmc()) {
            return this.forceInsertEmc(Math.min(this.getEmcInsertLimit(), toAccept), action);
        }
        return 0L;
    }

    protected long forceExtractEmc(long toExtract, IEmcStorage.EmcAction action) {
        if (toExtract < 0L) {
            return this.forceInsertEmc(-toExtract, action);
        }
        long toRemove = Math.min(this.getStoredEmc(), toExtract);
        if (action.execute()) {
            this.currentEMC -= toRemove;
        }
        return toRemove;
    }

    protected long forceInsertEmc(long toAccept, IEmcStorage.EmcAction action) {
        if (toAccept < 0L) {
            return this.forceExtractEmc(-toAccept, action);
        }
        long toAdd = Math.min(this.getNeededEmc(), toAccept);
        if (action.execute()) {
            this.currentEMC += toAdd;
        }
        return toAdd;
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        if (this.getStoredEmc() > this.getMaximumEmc()) {
            this.currentEMC = this.getMaximumEmc();
        }
        tag.func_74772_a("EMC", this.getStoredEmc());
        return tag;
    }

    public void func_145839_a(@Nonnull CompoundNBT tag) {
        super.func_145839_a(tag);
        long set = tag.func_74763_f("EMC");
        if (set > this.getMaximumEmc()) {
            set = this.getMaximumEmc();
        }
        this.currentEMC = set;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ProjectEAPI.EMC_STORAGE_CAPABILITY) {
            return this.emcStorageCapability.cast();
        }
        return super.getCapability(cap, side);
    }
}

