/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.nbt.INBTProcessor;
import moze_intel.projecte.config.PEModConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class NBTProcessorConfig {
    private static NBTProcessorConfig INSTANCE;
    private static ForgeConfigSpec spec;
    private static PEModConfig dummyConfig;
    private static final String ENABLED = "enabled";
    private static final String PERSISTENT = "persistent";
    private static final String MAIN_KEY = "processors";

    public static void setup(@Nonnull List<INBTProcessor> processors) {
        if (INSTANCE == null) {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            INSTANCE = new NBTProcessorConfig(builder, processors);
            spec = builder.build();
            dummyConfig = new PEModConfig(ModConfig.Type.SERVER, spec, PECore.MOD_CONTAINER, "processing");
        }
    }

    private NBTProcessorConfig(@Nonnull ForgeConfigSpec.Builder builder, @Nonnull List<INBTProcessor> processors) {
        builder.comment(new String[]{"This config is used to control which NBT Processors get used, and which ones actually contribute to the persistent NBT data that gets saved to knowledge/copied in a condenser.", "To disable an NBT Processor set the 'enabled' option for it to false.", "To disable an NBT Processor from contributing to the persistent data set the 'persistent' option for it to false. Note: that if there is no persistent' config option, the NBT Processor never has any persistent data.", "The config options in this file are synced from server to client, as the processors get used dynamically to calculate/preview EMC values for items and are not included in the synced EMC mappings."}).push(MAIN_KEY);
        for (INBTProcessor processor : processors) {
            builder.comment(processor.getDescription()).push(processor.getName());
            builder.define(ENABLED, processor.isAvailable());
            if (processor.hasPersistentNBT()) {
                builder.define(PERSISTENT, processor.usePersistentNBT());
            }
            builder.pop();
        }
        builder.pop();
    }

    public static boolean isEnabled(INBTProcessor processor) {
        return NBTProcessorConfig.getValue(processor, ENABLED);
    }

    public static boolean hasPersistent(INBTProcessor processor) {
        return NBTProcessorConfig.getValue(processor, PERSISTENT);
    }

    private static boolean getValue(INBTProcessor processor, String key) {
        return (Boolean)((ForgeConfigSpec.BooleanValue)spec.getValues().get(Arrays.asList(MAIN_KEY, processor.getName(), key))).get();
    }
}

