/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config;

import java.nio.file.Path;
import moze_intel.projecte.PECore;
import moze_intel.projecte.config.ClientConfig;
import moze_intel.projecte.config.CommonConfig;
import moze_intel.projecte.config.PEModConfig;
import moze_intel.projecte.config.ServerConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;

public class ProjectEConfig {
    public static final Path CONFIG_DIR = FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get().resolve("ProjectE"), (String)"ProjectE");
    public static final ServerConfig server;
    public static final CommonConfig common;
    public static final ClientConfig client;
    private static final ForgeConfigSpec serverSpec;
    private static final ForgeConfigSpec commonSpec;
    private static final ForgeConfigSpec clientSpec;

    public static void register() {
        ProjectEConfig.registerConfig(ModConfig.Type.SERVER, serverSpec, "server");
        ProjectEConfig.registerConfig(ModConfig.Type.COMMON, commonSpec, "common");
        ProjectEConfig.registerConfig(ModConfig.Type.CLIENT, clientSpec, "client");
    }

    private static void registerConfig(ModConfig.Type type, ForgeConfigSpec spec, String fileName) {
        PECore.MOD_CONTAINER.addConfig((ModConfig)new PEModConfig(type, spec, PECore.MOD_CONTAINER, fileName));
    }

    static {
        Pair serverConfiguration = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        server = (ServerConfig)serverConfiguration.getLeft();
        serverSpec = (ForgeConfigSpec)serverConfiguration.getRight();
        Pair commonConfiguration = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        common = (CommonConfig)commonConfiguration.getLeft();
        commonSpec = (ForgeConfigSpec)commonConfiguration.getRight();
        Pair clientConfiguration = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        client = (ClientConfig)clientConfiguration.getLeft();
        clientSpec = (ForgeConfigSpec)clientConfiguration.getRight();
    }
}

