/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config;

import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ServerConfig {
    public final Difficulty difficulty;
    public final Items items;
    public final Effects effects;
    public final Misc misc;
    public final Cooldown cooldown;

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("All of the config options in this file are server side and will be synced from server to client. ProjectE uses one \"server\" config file for all worlds, for convenience in going from one world to another, but makes it be a \"server\" config file so that forge will automatically sync it when we connect to a multiplayer server.").push("server");
        this.difficulty = new Difficulty(builder);
        this.items = new Items(builder);
        this.effects = new Effects(builder);
        this.misc = new Misc(builder);
        this.cooldown = new Cooldown(builder);
        builder.pop();
    }

    public static class Cooldown {
        public final Pedestal pedestal;
        public final Player player;

        private Cooldown(ForgeConfigSpec.Builder builder) {
            builder.push("cooldown");
            builder.comment(new String[]{"Cooldown (in ticks) for various features in ProjectE. A cooldown of -1 will disable the functionality.", "A cooldown of 0 will allow the actions to happen every tick. Use caution as a very low value on features that run automatically could cause TPS issues."}).push("cooldown");
            this.pedestal = new Pedestal(builder);
            this.player = new Player(builder);
            builder.pop();
        }

        public static class Pedestal {
            public final ForgeConfigSpec.IntValue archangel;
            public final ForgeConfigSpec.IntValue body;
            public final ForgeConfigSpec.IntValue evertide;
            public final ForgeConfigSpec.IntValue harvest;
            public final ForgeConfigSpec.IntValue ignition;
            public final ForgeConfigSpec.IntValue life;
            public final ForgeConfigSpec.IntValue repair;
            public final ForgeConfigSpec.IntValue swrg;
            public final ForgeConfigSpec.IntValue soul;
            public final ForgeConfigSpec.IntValue volcanite;
            public final ForgeConfigSpec.IntValue zero;

            private Pedestal(ForgeConfigSpec.Builder builder) {
                builder.comment("Cooldown for various items within the pedestal.").push("pedestal");
                this.archangel = builder.comment("Delay between Archangel Smite shooting arrows while in the pedestal.").defineInRange("archangel", 40, -1, Integer.MAX_VALUE);
                this.body = builder.comment("Delay between Body Stone healing 0.5 shanks while in the pedestal.").defineInRange("body", 10, -1, Integer.MAX_VALUE);
                this.evertide = builder.comment("Delay between Evertide Amulet trying to start rain while in the pedestal.").defineInRange("evertide", 20, -1, Integer.MAX_VALUE);
                this.harvest = builder.comment("Delay between Harvest Goddess trying to grow and harvest while in the pedestal.").defineInRange("harvest", 10, -1, Integer.MAX_VALUE);
                this.ignition = builder.comment("Delay between Ignition Ring trying to light entities on fire while in the pedestal.").defineInRange("ignition", 40, -1, Integer.MAX_VALUE);
                this.life = builder.comment("Delay between Life Stone healing both food and hunger by 0.5 shank/heart while in the pedestal.").defineInRange("life", 5, -1, Integer.MAX_VALUE);
                this.repair = builder.comment("Delay between Talisman of Repair trying to repair player items while in the pedestal.").defineInRange("repair", 20, -1, Integer.MAX_VALUE);
                this.swrg = builder.comment("Delay between SWRG trying to smite mobs while in the pedestal.").defineInRange("swrg", 70, -1, Integer.MAX_VALUE);
                this.soul = builder.comment("Delay between Soul Stone healing 0.5 hearts while in the pedestal.").defineInRange("soul", 10, -1, Integer.MAX_VALUE);
                this.volcanite = builder.comment("Delay between Volcanite Amulet trying to stop rain while in the pedestal.").defineInRange("volcanite", 20, -1, Integer.MAX_VALUE);
                this.zero = builder.comment("Delay between Zero Ring trying to extinguish entities and freezing ground while in the pedestal.").defineInRange("zero", 40, -1, Integer.MAX_VALUE);
                builder.pop();
            }
        }

        public static class Player {
            public final ForgeConfigSpec.IntValue projectile;
            public final ForgeConfigSpec.IntValue gemChest;
            public final ForgeConfigSpec.IntValue repair;
            public final ForgeConfigSpec.IntValue heal;
            public final ForgeConfigSpec.IntValue feed;

            private Player(ForgeConfigSpec.Builder builder) {
                builder.comment("Cooldown for various items in regards to a player.").push("player");
                this.projectile = builder.comment("A cooldown for firing projectiles").defineInRange("projectile", 0, -1, Integer.MAX_VALUE);
                this.gemChest = builder.comment("A cooldown for Gem Chestplate explosion").defineInRange("gemChest", 0, -1, Integer.MAX_VALUE);
                this.repair = builder.comment("Delay between Talisman of Repair trying to repair player items while in a player's inventory.").defineInRange("repair", 20, -1, Integer.MAX_VALUE);
                this.heal = builder.comment("Delay between heal attempts while in a player's inventory. (Soul Stone, Life Stone, Gem Helmet)").defineInRange("heal", 20, -1, Integer.MAX_VALUE);
                this.feed = builder.comment("Delay between feed attempts while in a player's inventory. (Body Stone, Life Stone, Gem Helmet)").defineInRange("feed", 20, -1, Integer.MAX_VALUE);
                builder.pop();
            }
        }
    }

    public static class Misc {
        public final ForgeConfigSpec.BooleanValue unsafeKeyBinds;
        public final ForgeConfigSpec.BooleanValue hwylaTOPDisplay;

        private Misc(ForgeConfigSpec.Builder builder) {
            builder.push("misc");
            this.unsafeKeyBinds = builder.comment("False requires your hand be empty for Gem Armor Offensive Abilities to be readied or triggered").define("unsafeKeyBinds", false);
            this.hwylaTOPDisplay = builder.comment("Shows the EMC value of blocks when looking at them in Hwyla or TOP").define("hwylaTOPDisplay", true);
            builder.pop();
        }
    }

    public static class Effects {
        public final ForgeConfigSpec.IntValue timePedBonus;
        public final ForgeConfigSpec.DoubleValue timePedMobSlowness;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> timeWatchTEBlacklist;
        public final ForgeConfigSpec.BooleanValue interdictionMode;

        private Effects(ForgeConfigSpec.Builder builder) {
            builder.push("effects");
            this.timePedBonus = builder.comment("Bonus ticks given by the Watch of Flowing Time while in the pedestal. 0 = effectively no bonus.").defineInRange("timePedBonus", 18, 0, 256);
            this.timePedMobSlowness = builder.comment("Factor the Watch of Flowing Time slows down mobs by while in the pedestal. Set to 1.0 for no slowdown.").defineInRange("timePedMobSlowness", 0.1, 0.0, 1.0);
            this.timeWatchTEBlacklist = builder.comment("Tile entity ID's that the Watch of Flowing Time should not give extra ticks to.").defineList("timeWatchTEBlacklist", Collections.singletonList("projecte:dm_pedestal"), element -> element instanceof String && ResourceLocation.func_208304_a((String)((String)element)) != null);
            this.interdictionMode = builder.comment("If true the Interdiction Torch only affects hostile mobs. If false it affects all non blacklisted living entities.").define("interdictionMode", true);
            builder.pop();
        }
    }

    public static class Items {
        public final ForgeConfigSpec.BooleanValue pickaxeAoeVeinMining;
        public final ForgeConfigSpec.BooleanValue harvBandGrass;
        public final ForgeConfigSpec.BooleanValue disableAllRadiusMining;
        public final ForgeConfigSpec.BooleanValue enableTimeWatch;
        public final ForgeConfigSpec.BooleanValue opEvertide;

        private Items(ForgeConfigSpec.Builder builder) {
            builder.push("items");
            this.pickaxeAoeVeinMining = builder.comment("Instead of vein mining the ore you right click with your Dark/Red Matter Pick/Star it vein mines all ores in an AOE around you like it did in ProjectE before version 1.4.4.").define("pickaxeAoeVeinMining", false);
            this.harvBandGrass = builder.comment("Allows the Harvest Goddess Band to passively grow tall grass, flowers, etc, on top of grass blocks.").define("harvBandGrass", false);
            this.disableAllRadiusMining = builder.comment("If set to true, disables all radius-based mining functionality (right click of tools)").define("disableAllRadiusMining", false);
            this.enableTimeWatch = builder.comment("Enable Watch of Flowing Time").define("enableTimeWatch", true);
            this.opEvertide = builder.comment("Allow the Evertide amulet to place water in dimensions that water evaporates. For example: The Nether.").define("opEvertide", false);
            builder.pop();
        }
    }

    public static class Difficulty {
        public final ForgeConfigSpec.BooleanValue craftableTome;
        public final ForgeConfigSpec.BooleanValue offensiveAbilities;
        public final ForgeConfigSpec.DoubleValue katarDeathAura;
        public final ForgeConfigSpec.DoubleValue covalenceLoss;
        public final ForgeConfigSpec.BooleanValue covalenceLossRounding;

        private Difficulty(ForgeConfigSpec.Builder builder) {
            builder.push("difficulty");
            this.craftableTome = builder.comment("The Tome of Knowledge can be crafted.").define("craftableTome", false);
            this.offensiveAbilities = builder.comment("Set to false to disable Gem Armor offensive abilities (helmet zap and chestplate explosion)").define("offensiveAbilities", false);
            this.katarDeathAura = builder.comment("Amount of damage Katar 'C' key deals").defineInRange("katarDeathAura", 1000.0, 0.0, 2.147483647E9);
            this.covalenceLoss = builder.comment("Adjusting this ratio changes how much EMC is received when burning a item. For example setting this to 0.5 will return half of the EMC cost.").defineInRange("covalenceLoss", 1.0, 0.1, 1.0);
            this.covalenceLossRounding = builder.comment("How rounding occurs when Covalence Loss results in a burn value less than 1 EMC. If true the value will be rounded up to 1. If false the value will be rounded down to 0.").define("covalenceLossRounding", true);
            builder.pop();
        }
    }
}

