/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.imc.CustomEMCRegistration;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.EMCMappingHandler;
import net.minecraft.resources.IResourceManager;

@EMCMapper
public class APICustomEMCMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    @EMCMapper.Instance
    public static final APICustomEMCMapper INSTANCE = new APICustomEMCMapper();
    private static final int PRIORITY_MIN_VALUE = 0;
    private static final int PRIORITY_MAX_VALUE = 512;
    private static final int PRIORITY_DEFAULT_VALUE = 1;
    private final Map<String, Map<NormalizedSimpleStack, Long>> customEMCforMod = new HashMap<String, Map<NormalizedSimpleStack, Long>>();

    private APICustomEMCMapper() {
    }

    public void registerCustomEMC(String modid, CustomEMCRegistration customEMCRegistration) {
        NormalizedSimpleStack stack = customEMCRegistration.getStack();
        if (stack == null) {
            return;
        }
        long emcValue = customEMCRegistration.getValue();
        if (emcValue < 0L) {
            emcValue = 0L;
        }
        PECore.debugLog("Mod: '{}' registered a custom EMC value of: '{}' for the NormalizedSimpleStack: '{}'", modid, emcValue, stack);
        this.customEMCforMod.computeIfAbsent(modid, k -> new HashMap()).put(stack, emcValue);
    }

    @Override
    public String getName() {
        return "APICustomEMCMapper";
    }

    @Override
    public String getDescription() {
        return "Allows other mods to easily set EMC values using the ProjectEAPI";
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, CommentedFileConfig config, IResourceManager resourceManager) {
        HashMap<String, Integer> priorityMap = new HashMap<String, Integer>();
        for (String modId : this.customEMCforMod.keySet()) {
            String configKey = this.getName() + ".priority." + (modId == null ? "__no_modid" : modId);
            int priority = EMCMappingHandler.getOrSetDefault(config, configKey, "Priority for this mod", 1);
            priorityMap.put(modId, priority);
        }
        ArrayList<String> modIds = new ArrayList<String>(this.customEMCforMod.keySet());
        modIds.sort(Comparator.comparingInt(priorityMap::get).reversed());
        for (String modId : modIds) {
            String modIdOrUnknown;
            String string = modIdOrUnknown = modId == null ? "unknown mod" : modId;
            if (!this.customEMCforMod.containsKey(modId)) continue;
            for (Map.Entry<NormalizedSimpleStack, Long> entry : this.customEMCforMod.get(modId).entrySet()) {
                long emc;
                NormalizedSimpleStack normStack = entry.getKey();
                if (this.isAllowedToSet(modId, normStack, emc = entry.getValue().longValue(), config)) {
                    mapper.setValueBefore(normStack, emc);
                    if (normStack instanceof NSSTag) {
                        ((NSSTag)normStack).forEachElement(normalizedSimpleStack -> mapper.setValueBefore((NormalizedSimpleStack)normalizedSimpleStack, emc));
                    }
                    PECore.debugLog("{} setting value for {} to {}", modIdOrUnknown, normStack, emc);
                    continue;
                }
                PECore.debugLog("Disallowed {} to set the value for {} to {}", modIdOrUnknown, normStack, emc);
            }
        }
    }

    private boolean isAllowedToSet(String modId, NormalizedSimpleStack stack, Long value, CommentedFileConfig config) {
        String comment;
        String resourceLocation = stack instanceof NSSItem ? ((NSSItem)stack).getResourceLocation().toString() : "IntermediateFakeItemsUsedInRecipes:";
        String modForItem = resourceLocation.substring(0, resourceLocation.indexOf(58));
        String configPath = String.format("permissions.%s.%s", modId, modForItem);
        String permission = EMCMappingHandler.getOrSetDefault(config, configPath, comment = String.format("Allow mod '%s' to set and or remove values for mod '%s'. Options: [both, set, remove, none]", modId, modForItem), "both");
        if (permission.equals("both")) {
            return true;
        }
        if (value == 0L) {
            return permission.equals("remove");
        }
        return permission.equals("set");
    }
}

