/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IExtendedMappingCollector;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.arithmetic.FullBigFractionArithmetic;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

@EMCMapper
public class FluidMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    private static final List<Pair<NormalizedSimpleStack, Pair<NormalizedSimpleStack, Integer>>> meltingAlt = new ArrayList<Pair<NormalizedSimpleStack, Pair<NormalizedSimpleStack, Integer>>>();

    private static void addForgeMelting(String itemTagId, String fluidName, int amount) {
        FluidMapper.addMelting(new ResourceLocation("forge", itemTagId), new ResourceLocation("forge", fluidName), amount);
    }

    private static void addMelting(ResourceLocation itemTagId, ResourceLocation fluidTag, int amount) {
        FluidMapper.addMelting(NSSItem.createTag(itemTagId), fluidTag, amount);
    }

    private static void addMelting(Item item, String fluidName, int amount) {
        FluidMapper.addMelting(NSSItem.createItem((IItemProvider)item), new ResourceLocation("forge", fluidName), amount);
    }

    private static void addMelting(Block block, String fluidName, int amount) {
        FluidMapper.addMelting(NSSItem.createItem((IItemProvider)block), new ResourceLocation("forge", fluidName), amount);
    }

    private static void addMelting(NormalizedSimpleStack stack, ResourceLocation fluidTag, int amount) {
        meltingAlt.add((Pair<NormalizedSimpleStack, Pair<NormalizedSimpleStack, Integer>>)Pair.of((Object)stack, (Object)Pair.of((Object)NSSFluid.createTag(fluidTag), (Object)amount)));
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, CommentedFileConfig config, IResourceManager resourceManager) {
        NSSFluid fluidTag = NSSFluid.createTag((Tag<Fluid>)FluidTags.field_206959_a);
        mapper.setValueBefore(fluidTag, Long.MIN_VALUE);
        fluidTag.forEachElement(normalizedSimpleStack -> mapper.setValueBefore((NormalizedSimpleStack)normalizedSimpleStack, Long.MIN_VALUE));
        mapper.addConversion(1000, (NormalizedSimpleStack)NSSFluid.createTag((Tag<Fluid>)FluidTags.field_206960_b), Collections.singletonList(NSSItem.createItem((IItemProvider)Blocks.field_150343_Z)));
        NSSItem bucketNSS = NSSItem.createItem((IItemProvider)Items.field_151133_ar);
        NormalizedSimpleStack fakeMilkFluid = NSSFake.create("fakeMilkFluid");
        mapper.setValueBefore(fakeMilkFluid, 16L);
        mapper.addConversion(1, (NormalizedSimpleStack)NSSItem.createItem((IItemProvider)Items.field_151117_aB), Arrays.asList(bucketNSS, fakeMilkFluid));
        NSSFluid milkNSS = NSSFluid.createTag(new ResourceLocation("forge", "milk"));
        mapper.addConversion(1000, (NormalizedSimpleStack)milkNSS, Collections.singletonList(fakeMilkFluid));
        if (!(mapper instanceof IExtendedMappingCollector)) {
            throw new RuntimeException("Cannot add Extended Fluid Mappings to mapper!");
        }
        IExtendedMappingCollector emapper = (IExtendedMappingCollector)mapper;
        FullBigFractionArithmetic fluidArithmetic = new FullBigFractionArithmetic();
        for (Pair<NormalizedSimpleStack, Pair<NormalizedSimpleStack, Integer>> pair : meltingAlt) {
            emapper.addConversion((int)((Integer)((Pair)pair.getValue()).getValue()), ((Pair)pair.getValue()).getKey(), Collections.singletonList(pair.getKey()), fluidArithmetic);
        }
        mapper.addConversion(1, (NormalizedSimpleStack)NSSItem.createItem((IItemProvider)Items.field_151131_as), (Map<NormalizedSimpleStack, Integer>)ImmutableMap.of((Object)bucketNSS, (Object)1, (Object)fluidTag, (Object)1000));
        mapper.addConversion(1, (NormalizedSimpleStack)NSSItem.createItem((IItemProvider)Items.field_151129_at), (Map<NormalizedSimpleStack, Integer>)ImmutableMap.of((Object)bucketNSS, (Object)1, (Object)NSSFluid.createTag((Tag<Fluid>)FluidTags.field_206960_b), (Object)1000));
        mapper.addConversion(1, (NormalizedSimpleStack)NSSItem.createItem((IItemProvider)Items.field_151117_aB), (Map<NormalizedSimpleStack, Integer>)ImmutableMap.of((Object)bucketNSS, (Object)1, (Object)milkNSS, (Object)1000));
    }

    @Override
    public String getName() {
        return "FluidMapper";
    }

    @Override
    public String getDescription() {
        return "Adds Conversions for fluid container items and fluids.";
    }

    static {
        FluidMapper.addMelting(Blocks.field_150343_Z, "molten/obisidan", 288);
        FluidMapper.addMelting(Blocks.field_150359_w, "molten/glass", 1000);
        FluidMapper.addMelting(Blocks.field_150410_aZ, "molten/glass", 250);
        FluidMapper.addMelting(Items.field_151079_bi, "molten/ender", 250);
        FluidMapper.addForgeMelting("ingots/iron", "molten/iron", 144);
        FluidMapper.addForgeMelting("ingots/gold", "molten/gold", 144);
        FluidMapper.addForgeMelting("ingots/copper", "molten/copper", 144);
        FluidMapper.addForgeMelting("ingots/tin", "molten/tin", 144);
        FluidMapper.addForgeMelting("ingots/silver", "molten/silver", 144);
        FluidMapper.addForgeMelting("ingots/lead", "molten/lead", 144);
        FluidMapper.addForgeMelting("ingots/nickel", "molten/nickel", 144);
        FluidMapper.addForgeMelting("ingots/aluminum", "molten/aluminum", 144);
        FluidMapper.addForgeMelting("ingots/ardite", "molten/ardite", 144);
        FluidMapper.addForgeMelting("ingots/cobalt", "molten/cobalt", 144);
        FluidMapper.addForgeMelting("ingots/platinum", "molten/platinum", 144);
        FluidMapper.addForgeMelting("ingots/obsidian", "molten/obsidian", 144);
        FluidMapper.addForgeMelting("ingots/electrum", "molten/electrum", 144);
        FluidMapper.addForgeMelting("ingots/invar", "molten/invar", 144);
        FluidMapper.addForgeMelting("ingots/signalum", "molten/signalum", 144);
        FluidMapper.addForgeMelting("ingots/lumium", "molten/lumium", 144);
        FluidMapper.addForgeMelting("ingots/enderium", "molten/enderium", 144);
        FluidMapper.addForgeMelting("ingots/mithril", "molten/mithril", 144);
        FluidMapper.addForgeMelting("ingots/bronze", "molten/bronze", 144);
        FluidMapper.addForgeMelting("ingots/aluminum_brass", "molten/aluminum_brass", 144);
        FluidMapper.addForgeMelting("ingots/manyullyn", "molten/manyullyn", 144);
        FluidMapper.addForgeMelting("ingots/alumite", "molten/alumite", 144);
        FluidMapper.addForgeMelting("gems/emerald", "emerald", 640);
        FluidMapper.addForgeMelting("dusts/redstone", "redstone", 100);
        FluidMapper.addForgeMelting("dusts/glowstone", "glowstone", 250);
        FluidMapper.addForgeMelting("dusts/cryotheum", "cryotheum", 100);
        FluidMapper.addForgeMelting("dusts/pryotheum", "pryotheum", 100);
    }
}

