/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.Arrays;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;

@EMCMapper
public class ShulkerBoxColoringMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, CommentedFileConfig config, IResourceManager resourceManager) {
        int recipeCount = 0;
        NSSItem nssBox = NSSItem.createItem((IItemProvider)Blocks.field_204409_il);
        for (DyeColor color : DyeColor.values()) {
            Block coloredShulkerBox = ShulkerBoxBlock.func_190952_a((DyeColor)color);
            if (coloredShulkerBox == Blocks.field_204409_il) continue;
            mapper.addConversion(1, (NormalizedSimpleStack)NSSItem.createItem((IItemProvider)coloredShulkerBox), Arrays.asList(nssBox, NSSItem.createTag((Tag<Item>)color.getTag())));
            ++recipeCount;
        }
        PECore.debugLog("ShulkerBoxColoringMapper Statistics:", new Object[0]);
        PECore.debugLog("Found {} Shulker Box Coloring Recipes", recipeCount);
    }

    @Override
    public String getName() {
        return "ShulkerBoxColoringMapper";
    }

    @Override
    public String getDescription() {
        return "Add Conversions for the recipes that recolor shulker boxes.";
    }
}

