/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.customConversions.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.mappers.customConversions.CustomConversionMapper;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversion;

public class CustomConversionDeserializer
implements JsonDeserializer<CustomConversion> {
    public CustomConversion deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        CustomConversion out = new CustomConversion();
        JsonObject o = json.getAsJsonObject();
        boolean foundOutput = false;
        boolean foundIngredients = false;
        for (Map.Entry entry : o.entrySet()) {
            JsonElement element = (JsonElement)entry.getValue();
            if ("count".equalsIgnoreCase((String)entry.getKey())) {
                out.count = element.getAsInt();
                continue;
            }
            if ("output".equals(entry.getKey())) {
                if (foundOutput) {
                    throw new JsonParseException("Multiple values for output field");
                }
                foundOutput = true;
                out.output = (NormalizedSimpleStack)context.deserialize((JsonElement)new JsonPrimitive(element.getAsString()), NormalizedSimpleStack.class);
                continue;
            }
            if ("ingredients".equals(entry.getKey())) {
                if (foundIngredients) {
                    throw new JsonParseException("Multiple values for ingredient field");
                }
                foundIngredients = true;
                if (element.isJsonArray()) {
                    HashMap<NormalizedSimpleStack, Integer> outMap = new HashMap<NormalizedSimpleStack, Integer>();
                    for (JsonElement e : element.getAsJsonArray()) {
                        NormalizedSimpleStack v = (NormalizedSimpleStack)context.deserialize((JsonElement)new JsonPrimitive(e.getAsString()), NormalizedSimpleStack.class);
                        outMap.merge(v, 1, Integer::sum);
                    }
                    out.ingredients = outMap;
                    continue;
                }
                if (element.isJsonObject()) {
                    out.ingredients = (Map)CustomConversionMapper.GSON.fromJson(element, new TypeToken<Map<NormalizedSimpleStack, Integer>>(){}.getType());
                    continue;
                }
                throw new JsonParseException("Could not parse ingredients!");
            }
            if (((String)entry.getKey()).equalsIgnoreCase("propagateTags")) {
                out.propagateTags = element.getAsBoolean();
                continue;
            }
            throw new JsonParseException(String.format("Unknown Key: %s in Conversion with value %s", entry.getKey(), element));
        }
        return out;
    }
}

