/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.recipe;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.utils.AnnotationHelper;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@EMCMapper
public class CraftingMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    private static final List<IRecipeTypeMapper> recipeMappers = new ArrayList<IRecipeTypeMapper>();

    public static void loadMappers() {
        if (recipeMappers.isEmpty()) {
            recipeMappers.addAll(AnnotationHelper.getRecipeTypeMappers());
        }
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, CommentedFileConfig config, IResourceManager resourceManager) {
        List<Object> unhandled;
        ResourceLocation typeRegistryName;
        HashMap<ResourceLocation, RecipeCountInfo> recipeCount = new HashMap<ResourceLocation, RecipeCountInfo>();
        HashSet<ResourceLocation> canNotMap = new HashSet<ResourceLocation>();
        RecipeManager recipeManager = ServerLifecycleHooks.getCurrentServer().func_199529_aN();
        for (IRecipeType recipeType : Registry.field_218367_H) {
            typeRegistryName = Registry.field_218367_H.func_177774_c((Object)recipeType);
            boolean wasHandled = false;
            Collection recipes = null;
            unhandled = new ArrayList();
            for (IRecipeTypeMapper iRecipeTypeMapper : recipeMappers) {
                String configKey = this.getName() + "." + iRecipeTypeMapper.getName() + ".enabled";
                if (!EMCMappingHandler.getOrSetDefault(config, configKey, iRecipeTypeMapper.getDescription(), iRecipeTypeMapper.isAvailable()).booleanValue() || !iRecipeTypeMapper.canHandle(recipeType)) continue;
                if (recipes == null) {
                    recipes = recipeManager.field_199522_d.getOrDefault(recipeType, Collections.emptyMap()).values();
                }
                int numHandled = 0;
                for (IRecipe recipe : recipes) {
                    try {
                        if (iRecipeTypeMapper.handleRecipe(mapper, recipe)) {
                            ++numHandled;
                            continue;
                        }
                        unhandled.add(recipe);
                    }
                    catch (Exception e) {
                        PECore.LOGGER.fatal("A fatal error occurred while trying to map the recipe: {}", (Object)recipe.func_199560_c());
                        throw e;
                    }
                }
                if (numHandled <= 0 && !recipes.isEmpty()) continue;
                if (recipeCount.containsKey(typeRegistryName)) {
                    ((RecipeCountInfo)recipeCount.get(typeRegistryName)).setUnhandled(unhandled);
                } else {
                    recipeCount.put(typeRegistryName, new RecipeCountInfo(recipes.size(), unhandled));
                }
                wasHandled = true;
                if (unhandled.isEmpty()) break;
                recipes = unhandled;
                unhandled = new ArrayList();
            }
            if (wasHandled) continue;
            canNotMap.add(typeRegistryName);
        }
        PECore.debugLog("CraftingMapper Statistics:", new Object[0]);
        for (Map.Entry entry : recipeCount.entrySet()) {
            typeRegistryName = (ResourceLocation)entry.getKey();
            RecipeCountInfo countInfo = (RecipeCountInfo)entry.getValue();
            int total = countInfo.getTotalRecipes();
            unhandled = countInfo.getUnhandled();
            PECore.debugLog("Found and handled {} of {} Recipes of Type {}", total - unhandled.size(), total, typeRegistryName);
            if (unhandled.isEmpty()) continue;
            PECore.debugLog("Unhandled Recipes of Type {}:", typeRegistryName);
            for (IRecipe iRecipe : unhandled) {
                PECore.debugLog("Name: {}, Recipe class: {}", iRecipe.func_199560_c(), iRecipe.getClass().getName());
            }
        }
        for (ResourceLocation typeRegistryName2 : canNotMap) {
            PECore.debugLog("Could not map any Recipes of Type: {}", typeRegistryName2);
        }
    }

    @Override
    public String getName() {
        return "CraftingMapper";
    }

    @Override
    public String getDescription() {
        return "Add Conversions for Crafting Recipes gathered from net.minecraft.item.crafting.RecipeManager";
    }

    private static class RecipeCountInfo {
        private final int totalRecipes;
        private List<IRecipe<?>> unhandled;

        private RecipeCountInfo(int totalRecipes, List<IRecipe<?>> unhandled) {
            this.totalRecipes = totalRecipes;
            this.unhandled = unhandled;
        }

        public int getTotalRecipes() {
            return this.totalRecipes;
        }

        public void setUnhandled(List<IRecipe<?>> unhandled) {
            this.unhandled = unhandled;
        }

        public List<IRecipe<?>> getUnhandled() {
            return this.unhandled;
        }
    }
}

