/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.items.PhilosophersStone;
import moze_intel.projecte.rendering.PERenderType;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="projecte", value={Dist.CLIENT})
public class TransmutationRenderingEvent {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static BlockState transmutationResult;

    @SubscribeEvent
    public static void preDrawHud(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && transmutationResult != null) {
            if (transmutationResult.func_177230_c() instanceof FlowingFluidBlock) {
                FluidAttributes resultAttributes = ((FlowingFluidBlock)transmutationResult.func_177230_c()).getFluid().getAttributes();
                int color = resultAttributes.getColor();
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
                TextureAtlasSprite sprite = (TextureAtlasSprite)mc.func_228015_a_(AtlasTexture.field_110575_b).apply(resultAttributes.getStillTexture());
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder wr = tessellator.func_178180_c();
                wr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                wr.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_227885_a_(red, green, blue, alpha).func_181675_d();
                wr.func_225582_a_(0.0, 16.0, 0.0).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_227885_a_(red, green, blue, alpha).func_181675_d();
                wr.func_225582_a_(16.0, 16.0, 0.0).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_227885_a_(red, green, blue, alpha).func_181675_d();
                wr.func_225582_a_(16.0, 0.0, 0.0).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_227885_a_(red, green, blue, alpha).func_181675_d();
                tessellator.func_78381_a();
            } else {
                RenderHelper.func_227780_a_();
                IBakedModel model = mc.func_175602_ab().func_184389_a(transmutationResult);
                mc.func_175599_af().func_191962_a(new ItemStack((IItemProvider)transmutationResult.func_177230_c()), 0, 0, model);
                RenderHelper.func_74518_a();
            }
        }
    }

    @SubscribeEvent
    public static void onOverlay(DrawHighlightEvent.HighlightBlock event) {
        ClientPlayerEntity player = TransmutationRenderingEvent.mc.field_71439_g;
        World world = player.func_130014_f_();
        ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
        if (stack.func_190926_b()) {
            stack = player.func_184586_b(Hand.OFF_HAND);
        }
        if (stack.func_190926_b() || stack.func_77973_b() != ObjHandler.philosStone) {
            transmutationResult = null;
            return;
        }
        RayTraceResult mop = ((PhilosophersStone)ObjHandler.philosStone).getHitBlock((PlayerEntity)player);
        if (mop instanceof BlockRayTraceResult) {
            BlockRayTraceResult rtr = (BlockRayTraceResult)mop;
            BlockState current = world.func_180495_p(rtr.func_216350_a());
            transmutationResult = WorldTransmutations.getWorldTransmutation(current, player.func_225608_bj_());
            if (transmutationResult != null) {
                ActiveRenderInfo activeRenderInfo = event.getInfo();
                Vec3d viewPosition = activeRenderInfo.func_216785_c();
                int charge = ((ItemMode)stack.func_77973_b()).getCharge(stack);
                byte mode = ((ItemMode)stack.func_77973_b()).getMode(stack);
                float alpha = (Boolean)ProjectEConfig.client.pulsatingOverlay.get() != false ? TransmutationRenderingEvent.getPulseProportion() * 0.6f : 0.35f;
                IVertexBuilder builder = event.getBuffers().getBuffer(PERenderType.transmutationOverlay());
                MatrixStack matrix = event.getMatrix();
                matrix.func_227860_a_();
                matrix.func_227861_a_(-viewPosition.field_72450_a, -viewPosition.field_72448_b, -viewPosition.field_72449_c);
                for (BlockPos pos : PhilosophersStone.getAffectedPositions(world, rtr.func_216350_a(), (PlayerEntity)player, rtr.func_216354_b(), mode, charge)) {
                    matrix.func_227860_a_();
                    matrix.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    matrix.func_227862_a_(1.02f, 1.02f, 1.02f);
                    matrix.func_227861_a_(-0.01, -0.01, -0.01);
                    Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
                    world.func_180495_p(pos).func_196954_c((IBlockReader)world, pos).func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                        float bMinX = (float)minX;
                        float bMinY = (float)minY;
                        float bMinZ = (float)minZ;
                        float bMaxX = (float)maxX;
                        float bMaxY = (float)maxY;
                        float bMaxZ = (float)maxZ;
                        builder.func_227888_a_(matrix4f, bMinX, bMaxY, bMinZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMaxX, bMaxY, bMinZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMaxX, bMaxY, bMaxZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMinX, bMaxY, bMaxZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMinX, bMinY, bMinZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMaxX, bMinY, bMinZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMaxX, bMinY, bMaxZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMinX, bMinY, bMaxZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMaxX, bMaxY, bMaxZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMinX, bMaxY, bMaxZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMinX, bMinY, bMaxZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMaxX, bMinY, bMaxZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMaxX, bMinY, bMinZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMinX, bMinY, bMinZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMinX, bMaxY, bMinZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMaxX, bMaxY, bMinZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMinX, bMaxY, bMaxZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMinX, bMaxY, bMinZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMinX, bMinY, bMinZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMinX, bMinY, bMaxZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMaxX, bMaxY, bMaxZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMaxX, bMaxY, bMinZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMaxX, bMinY, bMinZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                        builder.func_227888_a_(matrix4f, bMaxX, bMinY, bMaxZ).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                    });
                    matrix.func_227865_b_();
                }
                matrix.func_227865_b_();
            }
        } else {
            transmutationResult = null;
        }
    }

    private static float getPulseProportion() {
        return (float)(0.5 * Math.sin((double)System.currentTimeMillis() / 350.0) + 0.5);
    }
}

