/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.blocks.IMatterBlock;
import moze_intel.projecte.gameObjs.tiles.DMFurnaceTile;
import moze_intel.projecte.gameObjs.tiles.RMFurnaceTile;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MatterFurnace
extends AbstractFurnaceBlock
implements IMatterBlock {
    private final EnumMatterType matterType;

    public MatterFurnace(Block.Properties props, EnumMatterType type) {
        super(props);
        this.matterType = type;
    }

    @Nonnull
    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return this.matterType == EnumMatterType.RED_MATTER ? new RMFurnaceTile() : new DMFurnaceTile();
    }

    protected void func_220089_a(World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player) {
        if (!world.field_72995_K) {
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te.func_200662_C() == ObjHandler.DM_FURNACE_TILE) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((DMFurnaceTile)te), (BlockPos)pos);
            } else if (te != null && te.func_200662_C() == ObjHandler.RM_FURNACE_TILE) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((RMFurnaceTile)te), (BlockPos)pos);
            }
        }
    }

    @Deprecated
    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null) {
                tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> WorldHelper.dropInventory(inv, world, pos));
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public int func_180641_l(BlockState state, World world, @Nonnull BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            return (Integer)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(ItemHandlerHelper::calcRedstoneFromInventory).orElse((Object)0);
        }
        return 0;
    }

    @Override
    public EnumMatterType getMatterType() {
        return this.matterType;
    }
}

