/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.tiles.DMFurnaceTile;
import moze_intel.projecte.utils.ContainerHelper;
import moze_intel.projecte.utils.GuiHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraftforge.items.IItemHandler;

public class DMFurnaceContainer
extends Container {
    public final DMFurnaceTile tile;
    private int lastCookTime;
    private int lastBurnTime;
    private int lastItemBurnTime;

    public DMFurnaceContainer(ContainerType<?> type, int windowId, PlayerInventory invPlayer, DMFurnaceTile tile) {
        super(type, windowId);
        this.tile = tile;
        this.initSlots(invPlayer);
    }

    public DMFurnaceContainer(int windowId, PlayerInventory invPlayer, DMFurnaceTile tile) {
        this(ObjHandler.DM_FURNACE_CONTAINER, windowId, invPlayer, tile);
    }

    public static DMFurnaceContainer fromNetwork(int windowId, PlayerInventory invPlayer, PacketBuffer buffer) {
        return new DMFurnaceContainer(windowId, invPlayer, (DMFurnaceTile)GuiHandler.getTeFromBuf(buffer));
    }

    void initSlots(PlayerInventory invPlayer) {
        int j;
        int i;
        IItemHandler fuel = this.tile.getFuel();
        IItemHandler input = this.tile.getInput();
        IItemHandler output = this.tile.getOutput();
        this.func_75146_a((Slot)new ValidatedSlot(fuel, 0, 49, 53, SlotPredicates.FURNACE_FUEL));
        this.func_75146_a((Slot)new ValidatedSlot(input, 0, 49, 17, stack -> !this.tile.getSmeltingResult((ItemStack)stack).func_190926_b()));
        int counter = input.getSlots() - 1;
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 4; ++j) {
                this.func_75146_a((Slot)new ValidatedSlot(input, counter--, 13 + i * 18, 8 + j * 18, stack -> !this.tile.getSmeltingResult((ItemStack)stack).func_190926_b()));
            }
        }
        counter = output.getSlots() - 1;
        this.func_75146_a((Slot)new ValidatedSlot(output, counter--, 109, 35, s -> false));
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 4; ++j) {
                this.func_75146_a((Slot)new ValidatedSlot(output, counter--, 131 + i * 18, 8 + j * 18, s -> false));
            }
        }
        ContainerHelper.addPlayerInventory(arg_0 -> ((DMFurnaceContainer)this).func_75146_a(arg_0), (IInventory)invPlayer, 8, 84);
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        if (slotIndex <= 18) {
            if (!this.func_75135_a(stack, 19, 55, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (AbstractFurnaceTileEntity.func_213991_b((ItemStack)newStack) || newStack.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).isPresent()) {
            if (!this.func_75135_a(stack, 0, 1, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (!this.tile.getSmeltingResult(newStack).func_190926_b()) {
            if (!this.func_75135_a(stack, 1, 10, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return newStack;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return player.field_70170_p.func_180495_p(this.tile.func_174877_v()).func_177230_c() == ObjHandler.dmFurnace && player.func_70092_e((double)this.tile.func_174877_v().func_177958_n() + 0.5, (double)this.tile.func_174877_v().func_177956_o() + 0.5, (double)this.tile.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void func_75132_a(@Nonnull IContainerListener par1IContainerListener) {
        super.func_75132_a(par1IContainerListener);
        par1IContainerListener.func_71112_a((Container)this, 0, this.tile.furnaceCookTime);
        par1IContainerListener.func_71112_a((Container)this, 1, this.tile.furnaceBurnTime);
        par1IContainerListener.func_71112_a((Container)this, 2, this.tile.currentItemBurnTime);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener crafter : this.field_75149_d) {
            if (this.lastCookTime != this.tile.furnaceCookTime) {
                crafter.func_71112_a((Container)this, 0, this.tile.furnaceCookTime);
            }
            if (this.lastBurnTime != this.tile.furnaceBurnTime) {
                crafter.func_71112_a((Container)this, 1, this.tile.furnaceBurnTime);
            }
            if (this.lastItemBurnTime == this.tile.currentItemBurnTime) continue;
            crafter.func_71112_a((Container)this, 2, this.tile.currentItemBurnTime);
        }
        this.lastCookTime = this.tile.furnaceCookTime;
        this.lastBurnTime = this.tile.furnaceBurnTime;
        this.lastItemBurnTime = this.tile.currentItemBurnTime;
    }

    public void func_75137_b(int id, int data) {
        if (id == 0) {
            this.tile.furnaceCookTime = data;
        } else if (id == 1) {
            this.tile.furnaceBurnTime = data;
        } else if (id == 2) {
            this.tile.currentItemBurnTime = data;
        }
    }
}

