/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.container.PEContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import moze_intel.projecte.utils.ContainerHelper;
import moze_intel.projecte.utils.GuiHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IntReferenceHolder;
import net.minecraftforge.items.IItemHandler;

public class RelayMK1Container
extends PEContainer {
    public final RelayMK1Tile tile;
    private final IntReferenceHolder kleinChargeProgress = IntReferenceHolder.func_221492_a();
    private final IntReferenceHolder inputBurnProgress = IntReferenceHolder.func_221492_a();
    public final PEContainer.BoxedLong emc = new PEContainer.BoxedLong();

    public static RelayMK1Container fromNetwork(int windowId, PlayerInventory invPlayer, PacketBuffer buf) {
        return new RelayMK1Container(windowId, invPlayer, (RelayMK1Tile)GuiHandler.getTeFromBuf(buf));
    }

    public RelayMK1Container(int windowId, PlayerInventory invPlayer, RelayMK1Tile relay) {
        this(ObjHandler.RELAY_MK1_CONTAINER, windowId, invPlayer, relay);
    }

    protected RelayMK1Container(ContainerType<?> type, int windowId, PlayerInventory invPlayer, RelayMK1Tile relay) {
        super(type, windowId);
        this.longFields.add(this.emc);
        this.intFields.add(this.kleinChargeProgress);
        this.intFields.add(this.inputBurnProgress);
        this.tile = relay;
        this.initSlots(invPlayer);
    }

    void initSlots(PlayerInventory invPlayer) {
        IItemHandler input = this.tile.getInput();
        IItemHandler output = this.tile.getOutput();
        this.func_75146_a((Slot)new ValidatedSlot(input, 0, 67, 43, SlotPredicates.RELAY_INV));
        int counter = input.getSlots() - 1;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new ValidatedSlot(input, counter--, 27 + i * 18, 17 + j * 18, SlotPredicates.RELAY_INV));
            }
        }
        this.func_75146_a((Slot)new ValidatedSlot(output, 0, 127, 43, SlotPredicates.EMC_HOLDER));
        ContainerHelper.addPlayerInventory(arg_0 -> ((RelayMK1Container)this).func_75146_a(arg_0), (IInventory)invPlayer, 8, 95);
    }

    @Override
    public void func_75142_b() {
        this.emc.set(this.tile.getStoredEmc());
        this.kleinChargeProgress.func_221494_a((int)(this.tile.getItemChargeProportion() * 8000.0));
        this.inputBurnProgress.func_221494_a((int)(this.tile.getInputBurnProportion() * 8000.0));
        super.func_75142_b();
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        if (slotIndex < 8) {
            if (!this.func_75135_a(stack, 8, this.field_75151_b.size(), true)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75218_e();
        } else if (!this.func_75135_a(stack, 0, 7, false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return slot.func_190901_a(player, newStack);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return player.field_70170_p.func_180495_p(this.tile.func_174877_v()).func_177230_c() == ObjHandler.relay && player.func_70092_e((double)this.tile.func_174877_v().func_177958_n() + 0.5, (double)this.tile.func_174877_v().func_177956_o() + 0.5, (double)this.tile.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public double getKleinChargeProgress() {
        return (double)this.kleinChargeProgress.func_221495_b() / 8000.0;
    }

    public double getInputBurnProgress() {
        return (double)this.inputBurnProgress.func_221495_b() / 8000.0;
    }
}

