/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container.inventory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.api.event.PlayerAttemptLearnEvent;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.LazyOptionalHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TransmutationInventory
extends CombinedInvWrapper {
    public final PlayerEntity player;
    public final IKnowledgeProvider provider;
    private final IItemHandlerModifiable inputLocks;
    private final IItemHandlerModifiable learning;
    public final IItemHandlerModifiable outputs;
    private static final int LOCK_INDEX = 8;
    private static final int FUEL_START = 12;
    public int learnFlag = 0;
    public int unlearnFlag = 0;
    public String filter = "";
    public int searchpage = 0;
    private final List<ItemInfo> knowledge = new ArrayList<ItemInfo>();

    public TransmutationInventory(PlayerEntity player) {
        super(new IItemHandlerModifiable[]{(IItemHandlerModifiable)((IKnowledgeProvider)player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).orElseThrow(NullPointerException::new)).getInputAndLocks(), new ItemStackHandler(2), new ItemStackHandler(16)});
        this.player = player;
        this.provider = (IKnowledgeProvider)player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).orElseThrow(NullPointerException::new);
        this.inputLocks = this.itemHandler[0];
        this.learning = this.itemHandler[1];
        this.outputs = this.itemHandler[2];
        if (player.func_130014_f_().field_72995_K) {
            this.updateClientTargets();
        }
    }

    public void handleKnowledge(ItemStack stack) {
        if (!stack.func_190926_b()) {
            this.handleKnowledge(ItemInfo.fromStack(stack));
        }
    }

    public void handleKnowledge(ItemInfo info) {
        ItemInfo cleanedInfo = NBTManager.getPersistentInfo(info);
        if (!this.provider.hasKnowledge(cleanedInfo)) {
            if (!MinecraftForge.EVENT_BUS.post((Event)new PlayerAttemptLearnEvent(this.player, info, cleanedInfo))) {
                this.learnFlag = 300;
                this.unlearnFlag = 0;
                this.provider.addKnowledge(cleanedInfo);
            }
            if (!this.player.func_130014_f_().field_72995_K) {
                this.provider.sync((ServerPlayerEntity)this.player);
            }
        }
        this.updateClientTargets();
    }

    public void handleUnlearn(ItemStack stack) {
        if (!stack.func_190926_b()) {
            this.handleUnlearn(ItemInfo.fromStack(stack));
        }
    }

    public void handleUnlearn(ItemInfo info) {
        ItemInfo cleanedInfo = NBTManager.getPersistentInfo(info);
        if (this.provider.hasKnowledge(cleanedInfo)) {
            this.unlearnFlag = 300;
            this.learnFlag = 0;
            this.provider.removeKnowledge(cleanedInfo);
            if (!this.player.func_130014_f_().field_72995_K) {
                this.provider.sync((ServerPlayerEntity)this.player);
            }
        }
        this.updateClientTargets();
    }

    public void checkForUpdates() {
        long fuelEmc;
        long matterEmc = EMCHelper.getEmcValue(this.outputs.getStackInSlot(0));
        if (BigInteger.valueOf(Math.max(matterEmc, fuelEmc = EMCHelper.getEmcValue(this.outputs.getStackInSlot(12)))).compareTo(this.getAvailableEMC()) > 0) {
            this.updateClientTargets();
        }
    }

    public void updateClientTargets() {
        if (!this.player.func_130014_f_().field_72995_K) {
            return;
        }
        this.knowledge.clear();
        this.knowledge.addAll(this.provider.getKnowledge());
        this.knowledge.sort(Collections.reverseOrder(Comparator.comparing(EMCHelper::getEmcValue)));
        for (int i = 0; i < this.outputs.getSlots(); ++i) {
            this.outputs.setStackInSlot(i, ItemStack.field_190927_a);
        }
        int pagecounter = 0;
        int desiredPage = this.searchpage * 12;
        ItemInfo lockInfo = null;
        if (!this.inputLocks.getStackInSlot(8).func_190926_b()) {
            lockInfo = NBTManager.getPersistentInfo(ItemInfo.fromStack(this.inputLocks.getStackInSlot(8)));
            long reqEmc = EMCHelper.getEmcValue(lockInfo);
            if (this.getAvailableEMC().compareTo(BigInteger.valueOf(reqEmc)) < 0) {
                return;
            }
            Iterator<ItemInfo> iter = this.knowledge.iterator();
            while (iter.hasNext()) {
                ItemInfo info = iter.next();
                if (EMCHelper.getEmcValue(info) > reqEmc || info.equals(lockInfo) || !this.doesItemMatchFilter(info)) {
                    iter.remove();
                    continue;
                }
                if (pagecounter >= desiredPage) continue;
                ++pagecounter;
                iter.remove();
            }
        } else {
            Iterator<ItemInfo> iter = this.knowledge.iterator();
            while (iter.hasNext()) {
                ItemInfo info = iter.next();
                if (this.getAvailableEMC().compareTo(BigInteger.valueOf(EMCHelper.getEmcValue(info))) < 0 || !this.doesItemMatchFilter(info)) {
                    iter.remove();
                    continue;
                }
                if (pagecounter >= desiredPage) continue;
                ++pagecounter;
                iter.remove();
            }
        }
        int matterCounter = 0;
        int fuelCounter = 0;
        if (lockInfo != null && this.provider.hasKnowledge(lockInfo)) {
            ItemStack lockStack = lockInfo.createStack();
            if (FuelMapper.isStackFuel(lockStack)) {
                this.outputs.setStackInSlot(12, lockStack);
                ++fuelCounter;
            } else {
                this.outputs.setStackInSlot(0, lockStack);
                ++matterCounter;
            }
        }
        for (ItemInfo info : this.knowledge) {
            ItemStack stack = info.createStack();
            if (FuelMapper.isStackFuel(stack)) {
                if (fuelCounter >= 4) continue;
                this.outputs.setStackInSlot(12 + fuelCounter, stack);
                ++fuelCounter;
                continue;
            }
            if (matterCounter >= 12) continue;
            this.outputs.setStackInSlot(matterCounter, stack);
            ++matterCounter;
        }
    }

    private boolean doesItemMatchFilter(ItemInfo info) {
        if (this.filter.isEmpty()) {
            return true;
        }
        try {
            return info.createStack().func_200301_q().func_150261_e().toLowerCase(Locale.ROOT).contains(this.filter);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public void writeIntoOutputSlot(int slot, ItemStack item) {
        long emcValue = EMCHelper.getEmcValue(item);
        if (emcValue > 0L && BigInteger.valueOf(emcValue).compareTo(this.getAvailableEMC()) <= 0 && this.provider.hasKnowledge(item)) {
            this.outputs.setStackInSlot(slot, item);
        } else {
            this.outputs.setStackInSlot(slot, ItemStack.field_190927_a);
        }
    }

    public void addEmc(BigInteger value) {
        int compareToZero = value.compareTo(BigInteger.ZERO);
        if (compareToZero == 0) {
            return;
        }
        if (compareToZero < 0) {
            this.removeEmc(value.negate());
        }
        for (int i = 0; i < this.inputLocks.getSlots(); ++i) {
            long shrunkenValue;
            IItemEmcHolder emcHolder;
            long actualInserted;
            Optional holderCapability;
            ItemStack stack;
            if (i == 8 || (stack = this.inputLocks.getStackInSlot(i)).func_190926_b() || !(holderCapability = LazyOptionalHelper.toOptional(stack.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY))).isPresent() || (value = value.subtract(BigInteger.valueOf(actualInserted = (emcHolder = (IItemEmcHolder)holderCapability.get()).insertEmc(stack, shrunkenValue = MathUtils.clampToLong(value), IEmcStorage.EmcAction.EXECUTE)))).compareTo(BigInteger.ZERO) != 0) continue;
            return;
        }
        this.provider.setEmc(this.provider.getEmc().add(value));
        if (this.provider.getEmc().compareTo(BigInteger.ZERO) < 0) {
            this.provider.setEmc(BigInteger.ZERO);
        }
        if (!this.player.func_130014_f_().field_72995_K) {
            PlayerHelper.updateScore((ServerPlayerEntity)this.player, PlayerHelper.SCOREBOARD_EMC, this.provider.getEmc());
        }
    }

    public void removeEmc(BigInteger value) {
        int compareToZero = value.compareTo(BigInteger.ZERO);
        if (compareToZero == 0) {
            return;
        }
        if (compareToZero < 0) {
            this.addEmc(value.negate());
        }
        if (value.compareTo(this.provider.getEmc()) > 0) {
            long shrunkenToRemove;
            IItemEmcHolder emcHolder;
            long actualExtracted;
            Optional holderCapability;
            ItemStack stack;
            BigInteger toRemove = value.subtract(this.provider.getEmc());
            value = this.provider.getEmc();
            for (int i = 0; i < this.inputLocks.getSlots() && (i == 8 || (stack = this.inputLocks.getStackInSlot(i)).func_190926_b() || !(holderCapability = LazyOptionalHelper.toOptional(stack.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY))).isPresent() || (toRemove = toRemove.subtract(BigInteger.valueOf(actualExtracted = (emcHolder = (IItemEmcHolder)holderCapability.get()).extractEmc(stack, shrunkenToRemove = MathUtils.clampToLong(toRemove), IEmcStorage.EmcAction.EXECUTE)))).compareTo(BigInteger.ZERO) != 0); ++i) {
            }
        }
        this.provider.setEmc(this.provider.getEmc().subtract(value));
        if (this.provider.getEmc().compareTo(BigInteger.ZERO) < 0) {
            this.provider.setEmc(BigInteger.ZERO);
        }
        if (!this.player.func_130014_f_().field_72995_K) {
            PlayerHelper.updateScore((ServerPlayerEntity)this.player, PlayerHelper.SCOREBOARD_EMC, this.provider.getEmc());
        }
    }

    public IItemHandlerModifiable getHandlerForSlot(int slot) {
        return super.getHandlerFromIndex(super.getIndexForSlot(slot));
    }

    public int getIndexFromSlot(int slot) {
        for (IItemHandlerModifiable h : this.itemHandler) {
            if (slot < h.getSlots()) continue;
            slot -= h.getSlots();
        }
        return slot;
    }

    public BigInteger getAvailableEMC() {
        BigInteger emc = this.provider.getEmc();
        for (int i = 0; i < this.inputLocks.getSlots(); ++i) {
            Optional emcHolder;
            ItemStack stack;
            if (i == 8 || (stack = this.inputLocks.getStackInSlot(i)).func_190926_b() || !(emcHolder = LazyOptionalHelper.toOptional(stack.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY))).isPresent()) continue;
            emc = emc.add(BigInteger.valueOf(((IItemEmcHolder)emcHolder.get()).getStoredEmc(stack)));
        }
        return emc;
    }

    public int getKnowledgeSize() {
        return this.knowledge.size();
    }
}

