/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.Optional;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.gameObjs.container.AlchBagContainer;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.items.rings.BlackHoleBand;
import moze_intel.projecte.gameObjs.items.rings.VoidRing;
import moze_intel.projecte.utils.LazyOptionalHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class AlchemicalBag
extends ItemPE {
    public final DyeColor color;

    public AlchemicalBag(Item.Properties props, DyeColor color) {
        super(props);
        this.color = color;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProvider(player.func_184586_b(hand), hand), buf -> {
                buf.writeBoolean(hand == Hand.MAIN_HAND);
                buf.writeBoolean(false);
            });
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public static ItemStack getFirstBagWithSuctionItem(PlayerEntity player, NonNullList<ItemStack> inventory) {
        Optional cap = Optional.empty();
        for (ItemStack stack : inventory) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof AlchemicalBag)) continue;
            if (!cap.isPresent() && !(cap = LazyOptionalHelper.toOptional(player.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY))).isPresent()) break;
            IItemHandler inv = ((IAlchBagProvider)cap.get()).getBag(((AlchemicalBag)stack.func_77973_b()).color);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack ring = inv.getStackInSlot(i);
                if (ring.func_190926_b() || !(ring.func_77973_b() instanceof BlackHoleBand) && !(ring.func_77973_b() instanceof VoidRing) || !ring.func_77942_o() || !ring.func_77978_p().func_74767_n("Active")) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    private class ContainerProvider
    implements INamedContainerProvider {
        private final ItemStack stack;
        private final Hand hand;

        private ContainerProvider(ItemStack stack, Hand hand) {
            this.stack = stack;
            this.hand = hand;
        }

        @Nonnull
        public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerIn) {
            IItemHandlerModifiable inv = (IItemHandlerModifiable)((IAlchBagProvider)playerIn.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY).orElseThrow(NullPointerException::new)).getBag(AlchemicalBag.this.color);
            return new AlchBagContainer(windowId, playerInventory, this.hand, inv, false);
        }

        @Nonnull
        public ITextComponent func_145748_c_() {
            return this.stack.func_200301_q();
        }
    }
}

